/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.dataquality.DataQualityOutcome;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@UIModel
public class DataQualityDailyStatus {
    public final Scope scope;
    public final long computeTime;
    @Nullable
    public final AbstractCheckContext.CheckOutcome lastOutcome;
    @Nullable
    public final AbstractCheckContext.CheckOutcome worstOutcome;
    public final int numberLastOutcome;
    public final int numberWorstOutcome;
    public final int numberItems;

    protected DataQualityDailyStatus(Scope scope) {
        this.scope = scope;
        this.computeTime = -1L;
        this.lastOutcome = null;
        this.worstOutcome = null;
        this.numberLastOutcome = 0;
        this.numberWorstOutcome = 0;
        this.numberItems = 0;
    }

    public DataQualityDailyStatus(ReadOnlyJobsInternalDB.DataQualityProjectPoint pt) {
        this.scope = pt instanceof ReadOnlyJobsInternalDB.DataQualityPartitionPoint ? Scope.RULE : (pt instanceof ReadOnlyJobsInternalDB.DataQualityObjectPoint ? Scope.PARTITION : Scope.OBJECT);
        this.computeTime = pt.timestamp;
        this.lastOutcome = pt.last.getOutcome();
        this.numberLastOutcome = pt.last.getOutcomeCount();
        if (pt.worst.getOutcome() != null) {
            AbstractCheckContext.CheckOutcome actualWorst;
            this.worstOutcome = actualWorst = new DataQualityOutcome(Stream.of(pt.last.getOutcome(), pt.worst.getOutcome())).getOutcome();
            this.numberWorstOutcome = actualWorst == pt.worst.getOutcome() ? pt.worst.getOutcomeCount() : 0;
        } else {
            this.worstOutcome = null;
            this.numberWorstOutcome = 0;
        }
        this.numberItems = pt.last.errorCount + pt.last.warningCount + pt.last.okCount + pt.last.emptyCount;
    }

    public static DataQualityDailyStatus fromDataPoint(@Nullable ReadOnlyJobsInternalDB.DataQualityPartitionPoint pt) {
        return pt == null ? new DataQualityDailyStatus(Scope.RULE) : new DataQualityDailyStatus(pt);
    }

    public static DataQualityDailyStatus fromDataPoint(@Nullable ReadOnlyJobsInternalDB.DataQualityObjectPoint pt) {
        return pt == null ? new DataQualityDailyStatus(Scope.PARTITION) : new DataQualityDailyStatus(pt);
    }

    public static DataQualityDailyStatus fromDataPoint(@Nullable ReadOnlyJobsInternalDB.DataQualityProjectPoint pt) {
        return pt == null ? new DataQualityDailyStatus(Scope.OBJECT) : new DataQualityDailyStatus(pt);
    }

    public static enum Scope {
        OBJECT,
        PARTITION,
        RULE;

    }
}

