/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class UniversalSingleThreadPuller {
    private static Logger logger = Logger.getLogger((String)"dku.datasets.pull");

    public static RowInputStream pull(AuthCtx authCtx, Dataset dataset, StreamableDatasetSelection selection, ColumnFactory cf) {
        return UniversalSingleThreadPuller.pull(authCtx, dataset, selection, cf, null);
    }

    public static RowInputStream pull(final AuthCtx authCtx, final Dataset dataset, final StreamableDatasetSelection selection, final ColumnFactory cf, final WarningsContext wc) {
        final Stream stream = new Stream();
        final StreamRowFactory rf = new StreamRowFactory();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)("pull background thread starting for " + dataset.getName()));
                    try {
                        UniversalSingleThreadPusher.push(authCtx, dataset, selection, stream, cf, (RowFactory)rf, wc);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error in pull background thread, aborting push", (Throwable)e);
                        stream.fail(e);
                    }
                    catch (Throwable e) {
                        stream.fail(new Exception(e.getMessage(), e));
                    }
                    stream.lastRowEmitted();
                    logger.info((Object)("pull background thread finished for " + dataset.getName()));
                }
                catch (Throwable t) {
                    logger.error((Object)"Unexpected error in pull background thread, expect issues", t);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        return stream;
    }

    public static class Stream
    implements RowInputStream,
    ProcessorOutput {
        private LinkedBlockingQueue<RowOrPoison> queue = new LinkedBlockingQueue(2000);

        public void emitRow(Row r) throws InterruptedException {
            RowOrPoison rop = new RowOrPoison();
            rop.row = r;
            this.queue.put(rop);
        }

        public void fail(Exception e) throws InterruptedException {
            RowOrPoison rop = new RowOrPoison();
            rop.e = e;
            this.queue.put(rop);
        }

        public void lastRowEmitted() throws InterruptedException {
            logger.debug((Object)("pull background thread: ending queue,  cursize=" + this.queue.size()));
            RowOrPoison rop = new RowOrPoison();
            this.queue.put(rop);
        }

        public void cancel() throws InterruptedException {
            logger.debug((Object)("pull background thread: cancel queue,  cursize=" + this.queue.size()));
        }

        public void setMaxMemoryUsed(long size) {
        }

        public Row next() throws Exception {
            RowOrPoison r = this.queue.take();
            if (r.e != null) {
                throw new IOException("Reading data failed", r.e);
            }
            if (r.row == null) {
                logger.info((Object)"End of stream reached");
            }
            return r.row;
        }

        public static class RowOrPoison {
            Row row;
            Exception e;
        }
    }
}

