/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.hdfs;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.datasets.fs.hdfs.ACLUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.GroupImpersonationTarget;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.annotation.Autowired;

public class HDFSPermissionsUtils {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private ImpersonationResolverService impersonationService;

    public HDFSPermissionsUtils() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public List<AclEntry> getConnectionLevelACL(AuthCtx authCtx, String projectKey) throws IOException, InterruptedException, DKUSecurityException {
        HashSet<String> groupNames = new HashSet<String>();
        if (TransactionContext.hasAttachedTransaction()) {
            for (UsersDAO.Group g : this.usersDAO.listGroupsUnsafe()) {
                groupNames.add(g.name);
            }
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                for (UsersDAO.Group g : this.usersDAO.listGroupsUnsafe()) {
                    groupNames.add(g.name);
                }
            }
        }
        return this.getConnectionLevelACL_(authCtx, projectKey, groupNames);
    }

    private List<AclEntry> getConnectionLevelACL_(AuthCtx authCtx, String projectKey, Set<String> groupNames) throws IOException, InterruptedException, DKUSecurityException {
        String dssUserHadoopName = (String)Preconditions.checkNotNull((Object)UserGroupInformation.getLoginUser().getShortUserName());
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(authCtx, projectKey);
        return this.getConnectionLevelACLForClusterSettings(groupNames, dssUserHadoopName, clusterSettings);
    }

    public List<AclEntry> getConnectionLevelACL() throws IOException, InterruptedException, DKUSecurityException {
        HashSet<String> groupNames = new HashSet<String>();
        if (TransactionContext.hasAttachedTransaction()) {
            for (UsersDAO.Group g : this.usersDAO.listGroupsUnsafe()) {
                groupNames.add(g.name);
            }
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                for (UsersDAO.Group g : this.usersDAO.listGroupsUnsafe()) {
                    groupNames.add(g.name);
                }
            }
        }
        return this.getConnectionLevelACL_(groupNames);
    }

    private List<AclEntry> getConnectionLevelACL_(Set<String> groupNames) throws IOException, InterruptedException, DKUSecurityException {
        String dssUserHadoopName = (String)Preconditions.checkNotNull((Object)UserGroupInformation.getLoginUser().getShortUserName());
        ClusterSettings clusterSettings = new ClusterSelector().selectGlobal();
        return this.getConnectionLevelACLForClusterSettings(groupNames, dssUserHadoopName, clusterSettings);
    }

    private List<AclEntry> getConnectionLevelACLForClusterSettings(Set<String> groupNames, String dssUserHadoopName, ClusterSettings clusterSettings) throws DKUSecurityException {
        ArrayList<AclEntry> acls = new ArrayList<AclEntry>();
        HiveSettings hiveSettings = clusterSettings.getHiveSettings();
        ImpalaSettings impalaSettings = clusterSettings.getImpalaSettings();
        SparkSettings sparkSettings = clusterSettings.getSparkSettings();
        if (impalaSettings.enabled && !StringUtils.isBlank((String)impalaSettings.additionalUserToGrantAccessToWhenImpersonating)) {
            acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.USER, impalaSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.READ_EXECUTE));
        }
        if (!StringUtils.isBlank((String)hiveSettings.additionalUserToGrantAccessToWhenImpersonating)) {
            acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.USER, hiveSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.READ_EXECUTE));
        }
        HashSet<String> impersonatedGroups = new HashSet<String>();
        for (String groupName : groupNames) {
            GroupImpersonationTarget groupImpersonationTarget = this.impersonationService.getHadoopGroupOrNull(groupName);
            if (groupImpersonationTarget == null) continue;
            impersonatedGroups.add(groupImpersonationTarget.hadoopGroup);
        }
        for (String impersonatedGroup : impersonatedGroups) {
            acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, impersonatedGroup, FsAction.EXECUTE));
        }
        acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.USER, dssUserHadoopName, FsAction.ALL));
        acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.USER, null, FsAction.ALL));
        ACLUtils.dedupACLs(acls);
        acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, null, FsAction.NONE));
        acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.OTHER, null, FsAction.NONE));
        acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.MASK, null, FsAction.READ_EXECUTE));
        return acls;
    }
}

