/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UnpartitionedSQLTableDatasetHandler
extends AbstractSQLTableDatasetHandler {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    public UnpartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRecords();
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return true;
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw new IllegalArgumentException("It doesn't make sense to drop partitions on an unpartitioned SQL dataset");
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return new AbstractSQLTableDatasetHandler.TableClauseSplit(null);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (filter != null) : "Filter is required";
        if (this.rawAbstractConfig.variablesExpansionLoopConfig.isEnabled()) {
            logger.info((Object)("Filter has partition: " + filter.hasPartitionsFiltering() + " has filter " + String.valueOf(filter.getFilter() == null ? "false" : Boolean.valueOf(filter.getFilter().enabled))));
            if (filter.getFilter() == null || !filter.getFilter().enabled) {
                FilterResultWithSplits ret = new FilterResultWithSplits();
                ret.setNeedsRefilter(!this.isFullyTranslatable(filter));
                ret.withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
                return ret;
            }
            throw new IllegalArgumentException("Cannot handle input filter with repeating input dataset");
        }
        FilterResultWithSplits ret = new FilterResultWithSplits();
        ret.setNeedsRefilter(!this.isFullyTranslatable(filter));
        ret.withMatchingPartition(new Partition(null)).withSplit((InputSplit)new AbstractSQLTableDatasetHandler.TableClauseSplit(filter));
        return ret;
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        if (!this.rawAbstractConfig.variablesExpansionLoopConfig.isEnabled()) {
            return new AbstractSQLTableDatasetHandler.TableClauseSplit(null);
        }
        ArrayList<AbstractSQLTableDatasetHandler.TableClauseSplit> loopIterations = new ArrayList<AbstractSQLTableDatasetHandler.TableClauseSplit>();
        for (JsonObject jo : new VariablesExpansionLoopItemsIterable(this.authCtx, this.dataset.getProjectKey(), this.rawAbstractConfig.variablesExpansionLoopConfig)) {
            AutoCloseable ignored = DynamicLevelsStack.withLevel(jo);
            try {
                loopIterations.add(new AbstractSQLTableDatasetHandler.TableClauseSplit(null));
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return new RowSequenceInputSplit(loopIterations);
    }

    protected JsonObject createVELoopSampleIterationFailIfNone() {
        return VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(this.authCtx, this.dataset.getProjectKey(), this.rawAbstractConfig.variablesExpansionLoopConfig, "Repeating dataset is empty, cannot get sample");
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        try (AutoCloseable ignored = DynamicLevelsStack.withLevel(this.createVELoopSampleIterationFailIfNone());){
            AbstractSQLTableDatasetHandler.TableClauseSplit tableClauseSplit = new AbstractSQLTableDatasetHandler.TableClauseSplit(null);
            return tableClauseSplit;
        }
    }
}

