/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class RelatedRecipesIterable<I>
implements FlowPlaceholder.IterablePlaceholder<I, SerializedRecipe> {
    private final Class<I> input;
    private final boolean getSuccessors;

    protected RelatedRecipesIterable(Class<I> input, boolean getSuccessors) {
        this.input = input;
        this.getSuccessors = getSuccessors;
    }

    @Override
    public IterableDescription<I, SerializedRecipe> getDescription() {
        return IterableDescription.iterablePlaceholder(this.input, SerializedRecipe.class, "$recipe");
    }

    protected Collection<SerializedRecipe> getRelatedRecipes(FlowComputable flowComputable) {
        List<? extends GraphNode> resultAsNodes = this.getSuccessors ? flowComputable.getSuccessors() : flowComputable.getPredecessors();
        return resultAsNodes.stream().filter(successor -> successor instanceof FlowRecipe).map(successor -> ((FlowRecipe)successor).getModel()).collect(Collectors.toList());
    }

    public static class Mes
    extends RelatedRecipesIterable<ModelEvaluationStore> {
        public Mes(boolean getSuccessors) {
            super(ModelEvaluationStore.class, getSuccessors);
        }

        @Override
        public Collection<SerializedRecipe> resolve(FlowDocumentContext context, ModelEvaluationStore mes) throws PlaceholderExpectedException {
            return this.getRelatedRecipes(context.getProjectFlowGraph().getEvaluationStore(mes.projectKey, mes.id));
        }
    }

    public static class Model
    extends RelatedRecipesIterable<SavedModel> {
        public Model(boolean getSuccessors) {
            super(SavedModel.class, getSuccessors);
        }

        @Override
        public Collection<SerializedRecipe> resolve(FlowDocumentContext context, SavedModel model) throws PlaceholderExpectedException {
            return this.getRelatedRecipes(context.getProjectFlowGraph().getModel(model.projectKey, model.id));
        }
    }

    public static class Folder
    extends RelatedRecipesIterable<ManagedFolder> {
        public Folder(boolean getSuccessors) {
            super(ManagedFolder.class, getSuccessors);
        }

        @Override
        public Collection<SerializedRecipe> resolve(FlowDocumentContext context, ManagedFolder folder) throws PlaceholderExpectedException {
            return this.getRelatedRecipes(context.getProjectFlowGraph().getFolder(folder.projectKey, folder.id));
        }
    }

    public static class Dataset
    extends RelatedRecipesIterable<SerializedDataset> {
        public Dataset(boolean getSuccessors) {
            super(SerializedDataset.class, getSuccessors);
        }

        @Override
        public Collection<SerializedRecipe> resolve(FlowDocumentContext context, SerializedDataset dataset) throws PlaceholderExpectedException {
            return this.getRelatedRecipes(context.getProjectFlowGraph().getDataset(dataset.projectKey, dataset.name));
        }
    }
}

