/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;

public class SamplingRecipePlaceholders {
    private SamplingRecipePlaceholders() {
    }

    public static void assertIsSamplingRecipe(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        if (!SamplingRecipeMeta.META.getType().equals(sr.type)) {
            throw new BadTemplatePlaceholderException("This placeholder is only available for a Filter/Sample recipe. " + sr.name + " has type " + sr.type + ".");
        }
    }

    public static SamplingRecipeMeta.SamplingRecipeParams getParams(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        SamplingRecipePlaceholders.assertIsSamplingRecipe(sr);
        return (SamplingRecipeMeta.SamplingRecipeParams)sr.params;
    }

    public static FilterDesc getPayload(FlowDocumentContext context, SerializedRecipe sr) throws PlaceholderExpectedException {
        SamplingRecipePlaceholders.assertIsSamplingRecipe(sr);
        return (FilterDesc)JSON.parse((String)context.getCachedPayload(sr), FilterDesc.class);
    }

    public static class IsFiltered
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeBoolean(SamplingRecipePlaceholders.getPayload((FlowDocumentContext)context, (SerializedRecipe)recipe).enabled);
        }
    }

    public static class IsSampled
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeBoolean(!SamplingParam.SamplingMethod.FULL.equals((Object)SamplingRecipePlaceholders.getParams((SerializedRecipe)recipe).selection.samplingMethod));
        }
    }
}

