/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.common;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.FailedResult;
import com.dataiku.dip.eda.compute.computations.NotComputedResult;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class GroupedComputation
extends Computation {
    public static final String TYPE = "grouped";
    public Grouping grouping;
    public Computation computation;

    public GroupedComputation(Computation computation, Grouping grouping) {
        this.computation = computation;
        this.grouping = grouping;
    }

    private GroupedComputation() {
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    public static class GroupResult
    extends ImmutableValueObject {
        public Filter filter;
        public ComputationResult result;

        public GroupResult(Filter filter, ComputationResult result) {
            this.filter = filter;
            this.result = result;
        }

        private GroupResult() {
        }
    }

    public static class GroupedComputationResult
    extends AvailableResult
    implements Iterable<GroupResult> {
        public GroupingResult groups;
        public List<ComputationResult> results;

        public GroupedComputationResult(GroupingResult groups, List<ComputationResult> results) {
            this.groups = groups;
            this.results = results;
        }

        private GroupedComputationResult() {
        }

        @Override
        public List<String> collectWarnings() {
            ArrayList<String> output = new ArrayList<String>();
            for (ComputationResult result : this.results) {
                output.addAll(result.collectWarnings());
            }
            if (this.warnings != null) {
                output.addAll(this.warnings);
            }
            return output;
        }

        @Override
        public Collection<String> collectErrors() {
            return this.results.stream().map(ComputationResult::collectErrors).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        public GroupedComputationResult(GroupingResult groups, ComputationResult ... results) {
            this.groups = groups;
            this.results = Lists.newArrayList((Object[])results);
        }

        public List<GroupResult> getGroupedResults() {
            ArrayList<GroupResult> out = new ArrayList<GroupResult>();
            List<Filter> filters = this.groups.listFilters();
            for (int i = 0; i < filters.size(); ++i) {
                out.add(new GroupResult(filters.get(i), this.results.get(i)));
            }
            return out;
        }

        @Override
        public Iterator<GroupResult> iterator() {
            return this.getGroupedResults().iterator();
        }

        @Override
        public NotComputedResult getFirstNotComputedResult() {
            for (ComputationResult result : this.results) {
                NotComputedResult r = result.getFirstNotComputedResult();
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public FailedResult getFirstFailedResult() {
            for (ComputationResult result : this.results) {
                FailedResult r = result.getFirstFailedResult();
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public int getEstimatedMemoryUsageBytes() {
            int ret = 0;
            for (ComputationResult cur : this.results) {
                ret += cur.getEstimatedMemoryUsageBytes();
            }
            return ret;
        }

        @Override
        public ComputationResult.ComputationCounts getComputationCountsImpl() {
            ComputationResult.ComputationCounts ret = new ComputationResult.ComputationCounts(0, 0, 0);
            for (ComputationResult cur : this.results) {
                ComputationResult.ComputationCounts curCount = cur.getComputationCounts();
                ret = ret.add(curCount);
            }
            return ret;
        }

        @Override
        public List<ComputationResultDataStreamer.DataStreamId> getDataStreamIds() {
            ArrayList<ComputationResultDataStreamer.DataStreamId> streamIds = new ArrayList<ComputationResultDataStreamer.DataStreamId>();
            for (ComputationResult result : this.results) {
                streamIds.addAll(result.getDataStreamIds());
            }
            return streamIds;
        }
    }
}

