/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.timeseries;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.STLDecompositionParams;
import com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation;
import com.dataiku.dip.utils.ImmutableValueObject;

public class STLDecomposition
extends TimeSeriesComputation {
    public static final String TYPE = "stl_decomposition";
    private STLDecompositionParams params;

    public STLDecomposition(String seriesColumn, String timeColumn, STLDecompositionParams params) {
        this.seriesColumn = seriesColumn;
        this.timeColumn = timeColumn;
        this.params = params;
    }

    private STLDecomposition() {
    }

    public static class STLDecompositionResult
    extends AvailableResult {
        public String[] time;
        public double[] observed;
        public double[] trend;
        public double[] seasonal;
        public double[] resid;
        public STLGuessedParams guessedParams;

        @Override
        public int getEstimatedMemoryUsageBytes() {
            int nChars = 0;
            if (this.time.length > 0) {
                nChars = this.time.length * this.time[0].length();
            }
            int nDoubles = this.observed.length + this.trend.length + this.seasonal.length + this.resid.length;
            return 32 + 8 * nDoubles + 2 * nChars;
        }

        public static class STLGuessedParams
        extends ImmutableValueObject {
            public int period;
            public int trendSmoother;
            public int lowPassSmoother;
        }
    }

    public static enum DegreeMode {
        CONSTANT,
        CONSTANT_WITH_TREND;

    }

    public static enum DecompositionType {
        MULTIPLICATIVE,
        ADDITIVE;

    }
}

