/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.bivariate_header;

import com.dataiku.dip.eda.compute.computations.bivariate.Chi2IndTest;
import com.dataiku.dip.eda.compute.computations.bivariate.Covariance;
import com.dataiku.dip.eda.compute.computations.bivariate.KendallTau;
import com.dataiku.dip.eda.compute.computations.bivariate.MutualInformation;
import com.dataiku.dip.eda.compute.computations.bivariate.Pearson;
import com.dataiku.dip.eda.compute.computations.bivariate.Spearman;
import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.KsTest2Samp;
import com.dataiku.dip.eda.compute.computations.univariate.MoodTestNSamp;
import com.dataiku.dip.eda.compute.computations.univariate.OneWayAnova;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.AllFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.MissingValueFilter;
import com.dataiku.dip.eda.compute.filtering.NotFilter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceInterval;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.SummaryStats;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.List;

public class BivariateSummaryStatsCard
extends BivariateCard
implements CardWithConfidenceLevel,
CardWithConfidenceInterval {
    public static final String TYPE = "bivariate_summary";
    double confidenceLevel;
    boolean showConfidenceInterval;
    StatsToCompute compute = new StatsToCompute();

    private SummaryStats.ComputableStat makePearson(String flagName) {
        return new SummaryStats.ComputableStat<Pearson, Pearson.PearsonResult>(flagName, "Pearson"){

            @Override
            public Pearson getComputationPlan() {
                return new Pearson(BivariateSummaryStatsCard.this.xColumn.name, BivariateSummaryStatsCard.this.yColumn.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Pearson.PearsonResult result) {
                return this.floatResultWithPValue(result.correlation, result.pvalue);
            }
        };
    }

    private SummaryStats.ComputableStat makeKendallTau(String flagName) {
        return new SummaryStats.ComputableStat<KendallTau, KendallTau.KendallTauResult>(flagName, "Kendall tau"){

            @Override
            public KendallTau getComputationPlan() {
                return new KendallTau(BivariateSummaryStatsCard.this.xColumn.name, BivariateSummaryStatsCard.this.yColumn.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(KendallTau.KendallTauResult result) {
                return this.floatResultWithPValue(result.correlation, result.pvalue);
            }
        };
    }

    private SummaryStats.ComputableStat makeSpearman(String flagName) {
        return new SummaryStats.ComputableStat<Spearman, Spearman.SpearmanResult>(flagName, "Spearman"){

            @Override
            public Spearman getComputationPlan() {
                return new Spearman(BivariateSummaryStatsCard.this.xColumn.name, BivariateSummaryStatsCard.this.yColumn.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Spearman.SpearmanResult result) {
                return this.floatResultWithPValue(result.correlation, result.pvalue);
            }
        };
    }

    private SummaryStats.ComputableStat makeCovariance(String flagName) {
        return new SummaryStats.ComputableStat<Covariance, Covariance.CovarianceResult>(flagName, "Covariance"){

            @Override
            public Covariance getComputationPlan() {
                return new Covariance(BivariateSummaryStatsCard.this.xColumn.name, BivariateSummaryStatsCard.this.yColumn.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Covariance.CovarianceResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeCountComplete(String flagName) {
        Object fullLabel = this.xColumn.isContinuous() && this.yColumn.isContinuous() ? "Count of records where both " + this.xColumn.name + " and " + this.yColumn.name + " are not missing" : (this.xColumn.isContinuous() ? "Count of records where " + this.xColumn.name + " is not missing" : (this.yColumn.isContinuous() ? "Count of records where " + this.yColumn.name + " is not missing" : "Count of records"));
        return new SummaryStats.ComputableStat<GroupedComputation, GroupedComputation.GroupedComputationResult>(flagName, "N finite", (String)fullLabel){

            @Override
            public GroupedComputation getComputationPlan() {
                Filter filter = new AllFilter();
                if (BivariateSummaryStatsCard.this.xColumn.isContinuous()) {
                    filter = ((Filter)filter).and(new NotFilter(new MissingValueFilter(BivariateSummaryStatsCard.this.xColumn.name)));
                }
                if (BivariateSummaryStatsCard.this.yColumn.isContinuous()) {
                    filter = ((Filter)filter).and(new NotFilter(new MissingValueFilter(BivariateSummaryStatsCard.this.yColumn.name)));
                }
                return new GroupedComputation(new Count(), new SubsetGrouping(filter));
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                long count = result.results.get((int)0).as(Count.CountResult.class).count;
                return this.intResult(count);
            }
        };
    }

    private SummaryStats.ComputableStat makeMutualInformation(String flagName) {
        return new SummaryStats.ComputableStat<MutualInformation, MutualInformation.MutualInformationResult>(flagName, "NMI", "Normalized Mutual Information"){

            @Override
            public MutualInformation getComputationPlan() {
                return new MutualInformation(BivariateSummaryStatsCard.this.xColumn.name, BivariateSummaryStatsCard.this.yColumn.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(MutualInformation.MutualInformationResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeTotalCount(String flagName) {
        return new SummaryStats.ComputableStat<Count, Count.CountResult>(flagName, "N values"){

            @Override
            public Count getComputationPlan() {
                return new Count();
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Count.CountResult result) {
                return this.intResult(result.count);
            }
        };
    }

    private SummaryStats.ComputableStat makeChi2(String flagName) {
        return new SummaryStats.ComputableStat<Chi2IndTest, Chi2IndTest.Chi2IndTestResult>(flagName, "Chi-square", "Chi-square independence test"){

            @Override
            public Chi2IndTest getComputationPlan() {
                AnumGrouping xGrouping = new AnumGrouping(BivariateSummaryStatsCard.this.xColumn.name, null, false);
                AnumGrouping yGrouping = new AnumGrouping(BivariateSummaryStatsCard.this.yColumn.name, null, false);
                return new Chi2IndTest(xGrouping, yGrouping);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Chi2IndTest.Chi2IndTestResult result) {
                return this.floatResultWithPValue(result.statistic, result.pvalue);
            }
        };
    }

    private SummaryStats.ComputableStat makeOneWayAnova(String flagName) {
        Variable categoricalColumn;
        Variable numericalColumn;
        if (this.xColumn.isCategorical() && this.yColumn.isContinuous()) {
            numericalColumn = this.yColumn;
            categoricalColumn = this.xColumn;
        } else {
            numericalColumn = this.xColumn;
            categoricalColumn = this.yColumn;
        }
        String fullLabel = String.format("Compare mean of %s for each %s", numericalColumn.name, categoricalColumn.name);
        return new SummaryStats.ComputableStat<OneWayAnova, OneWayAnova.OneWayAnovaResult>(flagName, "One-way ANOVA", fullLabel){

            @Override
            public OneWayAnova getComputationPlan() {
                AnumGrouping xGrouping = new AnumGrouping(categoricalColumn.name, 10, false);
                return new OneWayAnova(numericalColumn.name, xGrouping, BivariateSummaryStatsCard.this.confidenceLevel);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(OneWayAnova.OneWayAnovaResult result) {
                return this.floatResultWithPValue(result.statistic, result.pvalue);
            }
        };
    }

    private SummaryStats.ComputableStat makeNSampleMood(String flagName) {
        Variable categoricalColumn;
        Variable numericalColumn;
        if (this.xColumn.isCategorical() && this.yColumn.isContinuous()) {
            numericalColumn = this.yColumn;
            categoricalColumn = this.xColumn;
        } else {
            numericalColumn = this.xColumn;
            categoricalColumn = this.yColumn;
        }
        String fullLabel = String.format("Compare median of %s for each %s", numericalColumn.name, categoricalColumn.name);
        return new SummaryStats.ComputableStat<MoodTestNSamp, MoodTestNSamp.MoodTestNSampResult>(flagName, "N-sample Mood", fullLabel){

            @Override
            public MoodTestNSamp getComputationPlan() {
                AnumGrouping xGrouping = new AnumGrouping(categoricalColumn.name, 10, false);
                return new MoodTestNSamp(numericalColumn.name, xGrouping);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(MoodTestNSamp.MoodTestNSampResult result) {
                return this.floatResultWithPValue(result.statistic, result.pvalue);
            }
        };
    }

    private SummaryStats.ComputableStat makeKolmogorovSmirnov(String flagName) {
        Variable categoricalColumn;
        Variable numericalColumn;
        if (this.xColumn.isCategorical() && this.yColumn.isContinuous()) {
            numericalColumn = this.yColumn;
            categoricalColumn = this.xColumn;
        } else {
            numericalColumn = this.xColumn;
            categoricalColumn = this.yColumn;
        }
        String fullLabel = String.format("Compare distribution of %s for the two most common values from %s", numericalColumn.name, categoricalColumn.name);
        return new SummaryStats.ComputableStat<KsTest2Samp, KsTest2Samp.KsTest2SampResult>(flagName, "Kolmogorov-Smirnov", fullLabel){

            @Override
            public KsTest2Samp getComputationPlan() {
                AnumGrouping xGrouping = new AnumGrouping(categoricalColumn.name, 2, false);
                return new KsTest2Samp(numericalColumn.name, xGrouping);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(KsTest2Samp.KsTest2SampResult result) {
                return this.floatResultWithPValue(result.statistic, result.pvalue);
            }
        };
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        boolean continuousCategoricalPair;
        final SummaryStats summaryStats = new SummaryStats();
        boolean bothContinuous = this.xColumn.isContinuous() && this.yColumn.isContinuous();
        boolean bothCategorical = this.xColumn.isCategorical() && this.yColumn.isCategorical();
        boolean bl = continuousCategoricalPair = this.xColumn.isContinuous() && this.yColumn.isCategorical() || this.xColumn.isCategorical() && this.yColumn.isContinuous();
        if (this.compute.spearman && bothContinuous) {
            summaryStats.addStat(this.makeSpearman("spearman"));
        }
        if (this.compute.pearson && bothContinuous) {
            summaryStats.addStat(this.makePearson("pearson"));
        }
        if (this.compute.totalCount) {
            summaryStats.addStat(this.makeTotalCount("totalCount"));
        }
        if (this.compute.covariance && bothContinuous) {
            summaryStats.addStat(this.makeCovariance("covariance"));
        }
        if (this.compute.kendallTau && bothContinuous) {
            summaryStats.addStat(this.makeKendallTau("kendallTau"));
        }
        if (this.compute.mutualInformation && bothCategorical) {
            summaryStats.addStat(this.makeMutualInformation("mutualInformation"));
        }
        if (this.compute.completeCount) {
            summaryStats.addStat(this.makeCountComplete("completeCount"));
        }
        if (this.compute.chi2 && bothCategorical) {
            summaryStats.addStat(this.makeChi2("chi2"));
        }
        if (this.compute.nSampleMood && continuousCategoricalPair) {
            summaryStats.addStat(this.makeNSampleMood("nSampleMood"));
        }
        if (this.compute.oneWayAnova && continuousCategoricalPair) {
            summaryStats.addStat(this.makeOneWayAnova("oneWayAnova"));
        }
        if (this.compute.kolmogorovSmirnov && continuousCategoricalPair) {
            summaryStats.addStat(this.makeKolmogorovSmirnov("kolmogorovSmirnov"));
        }
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                return summaryStats.getComputationPlan();
            }

            @Override
            protected CardResult buildFromAvailableResult(MultiComputation.MultiComputationResult result, ComputationResultDataStreamer dataStreamer) {
                return new BivariateSummaryStatsCardResult(summaryStats.getComputedStats(result));
            }
        };
    }

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public void setShowConfidenceInterval(boolean showConfidenceInterval) {
        this.showConfidenceInterval = showConfidenceInterval;
    }

    static class StatsToCompute {
        boolean spearman = true;
        boolean pearson = true;
        boolean totalCount = true;
        boolean covariance = true;
        boolean kendallTau = true;
        boolean mutualInformation = true;
        boolean completeCount = true;
        boolean chi2 = false;
        boolean oneWayAnova = false;
        boolean nSampleMood = false;
        boolean kolmogorovSmirnov = false;

        StatsToCompute() {
        }
    }

    public static class BivariateSummaryStatsCardResult
    extends CardResult {
        public List<SummaryStats.ComputedStat> stats;

        public BivariateSummaryStatsCardResult(List<SummaryStats.ComputedStat> stats) {
            this.stats = stats;
        }

        private BivariateSummaryStatsCardResult() {
        }
    }
}

