/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ExportEvaluationSampleInput
implements ExportInput {
    private static final String SPLIT_COLUMN_NAME = "row_origin";
    private static final String SPLIT_COLUMN_EVALUATION_SAMPLE_VALUE = "current";
    private static final String SPLIT_COLUMN_REFERENCE_SAMPLE_VALUE = "reference";
    private Schema sampleSchema;
    private final Schema referenceSchema;
    private File evaluationSampleFile;
    private final File referenceSampleFile;
    private final ExportInput.InputDescription description;
    private final FullModelEvaluationId fmeId;
    private StreamRowFactory rowFactory;
    private ColumnFactory columnFactory;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.evaluation.export");

    public ExportEvaluationSampleInput(FullModelEvaluationId fmeId) throws Exception {
        this.fmeId = fmeId;
        if (fmeId.isLLM()) {
            this.referenceSampleFile = null;
            this.referenceSchema = null;
            this.evaluationSampleFile = fmeId.getSampleWithMetricsFile();
            this.sampleSchema = fmeId.getSampleWithMetricsSchema();
        } else {
            this.evaluationSampleFile = fmeId.getSampleScoredFile();
            if (!this.evaluationSampleFile.isFile() || !this.evaluationSampleFile.exists()) {
                logger.debugV("Scored sample not found for %s. Trying non scored sample.", new Object[]{fmeId.toString()});
                this.evaluationSampleFile = fmeId.getSampleFile();
                if (!this.evaluationSampleFile.isFile() || !this.evaluationSampleFile.exists()) {
                    throw new IllegalArgumentException("Cannot export dataset. Model Evaluation contains no evaluation sample.");
                }
                this.sampleSchema = fmeId.getSampleSchema();
            } else {
                this.sampleSchema = fmeId.getScoredSchema();
            }
            if (fmeId.hasDriftReference()) {
                if (this.sampleSchema.hasColumn(SPLIT_COLUMN_NAME)) {
                    logger.warnV("Evaluation sample already contains a column called '%s'. Not exporting reference sample.", new Object[]{SPLIT_COLUMN_NAME});
                    this.referenceSampleFile = null;
                    this.referenceSchema = null;
                } else {
                    this.sampleSchema.addColumn(SPLIT_COLUMN_NAME, Type.STRING);
                    this.referenceSampleFile = fmeId.getDriftReferenceFile();
                    this.referenceSchema = fmeId.getDriftReferenceSchema();
                }
            } else {
                logger.debugV("%s contains no reference sample", new Object[]{fmeId.toString()});
                this.referenceSampleFile = null;
                this.referenceSchema = null;
            }
        }
        this.description = new ExportInput.InputDescription();
        if (null != this.referenceSampleFile) {
            this.description.name = "Evaluation and reference samples export";
            this.description.description = "Export the evaluation and reference samples to a new dataset.";
        } else {
            this.description.name = "Evaluation sample export";
            this.description.description = "Export the evaluation sample to a new dataset.";
        }
        this.description.projectKey = fmeId.getProjectKey();
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        this.rowFactory = new StreamRowFactory();
        this.columnFactory = cf;
    }

    @Override
    public long getInputSize() {
        return -1L;
    }

    @Override
    public ExportInput.InputDescription describe() {
        return this.description;
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.sampleSchema;
    }

    @Override
    public void stream(ProcessorOutput output) throws Exception {
        this.streamOneFile(output, this.evaluationSampleFile, this.sampleSchema, null != this.referenceSampleFile ? SPLIT_COLUMN_EVALUATION_SAMPLE_VALUE : null);
        if (null != this.referenceSampleFile) {
            this.streamOneFile(output, this.referenceSampleFile, this.referenceSchema, SPLIT_COLUMN_REFERENCE_SAMPLE_VALUE);
        }
        output.lastRowEmitted();
    }

    private void streamOneFile(ProcessorOutput output, File file, Schema fileSchema, String splitColumnValue) throws Exception {
        try (InputStream gis = DKUFileUtils.readWithAutoDecompress((File)file);){
            CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
            RFC4180CSVParser csvParser = new RFC4180CSVParser((LineReader)new InputStreamLineReader(gis, config.charset), config.getSeparatorChar());
            ArrayList<Column> schemaColumns = new ArrayList<Column>();
            for (SchemaColumn sc : this.sampleSchema.getColumns()) {
                schemaColumns.add(this.columnFactory.column(sc.getName()));
            }
            Column splitColumn = null != splitColumnValue ? (Column)schemaColumns.get(schemaColumns.size() - 1) : null;
            List fileSchemaColumns = fileSchema.getColumns();
            ArrayList<Integer> columnMapping = new ArrayList<Integer>();
            for (SchemaColumn fileCol : fileSchemaColumns) {
                columnMapping.add(this.sampleSchema.getColumnIndex(fileCol.getName()));
            }
            ArrayList<String> csvRow = new ArrayList<String>();
            while (csvParser.next(csvRow)) {
                int csvRowNumCols = csvRow.size();
                Row row = this.rowFactory.row();
                for (int i = 0; i < csvRowNumCols; ++i) {
                    Integer mapping = (Integer)columnMapping.get(i);
                    if (null == mapping) continue;
                    row.put((Column)schemaColumns.get(mapping), (String)csvRow.get(i));
                }
                if (null != splitColumn) {
                    row.put(splitColumn, splitColumnValue);
                }
                output.emitRow(row);
            }
        }
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return DSSFuturePayloadUtils.forFME(this.fmeId);
    }

    @Override
    public void close() {
    }
}

