/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.avro;

import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.avro.AvroFormatMeta;
import com.dataiku.dip.input.formats.BinaryHeader;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class AvroFormatDetector {
    private static final byte[] AVRO_MAGIC = new byte[]{79, 98, 106, 1};

    public List<InputFormatsDetector.FormatWithMetadata> detect(BinaryHeader header) {
        if (header.bytes.length < 4) {
            return Collections.emptyList();
        }
        if (Arrays.equals(AVRO_MAGIC, Arrays.copyOfRange(header.bytes, 0, AVRO_MAGIC.length))) {
            InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
            fwm.detectionScore = 601.0;
            fwm.params = new AvroFormatConfig();
            fwm.type = AvroFormatMeta.META.getType();
            fwm.metadata = new HashMap<String, String>();
            return Arrays.asList(fwm);
        }
        return Collections.emptyList();
    }
}

