/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.geo;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.geo.ShapefileOutputFormatter;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ShapefileFormatExtractor
implements FormatExtractor {
    public static final String DOC_URL = "https://doc.dataiku.com/dss/latest/formats/shapefile.html";
    public static final FormatMeta<ShapefileFormatExtractor, Config> META = new FormatMeta<ShapefileFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "shapefile";
        }

        @Override
        public String getLabel() {
            return "Shapefile";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{ParamDesc.booleanP("convertToWGS84", "Auto-convert to GPS coordinates", "Shapefiles can contain data in many coordinates system. DSS can auto-convert them to standard GPS coordinates", true), ParamDesc.booleanP("extractOriginalGeometryProperty", "Extract the raw geometry property", "Extract the 'raw' (unprojected) version of the geometry data", false)};
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new ShapefileFormatExtractor((Config)params);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new ShapefileOutputFormatter((Config)params);
        }
    };
    private Config params;
    private ExtractionLimit limit;
    private int extractedRows;
    public static final String geoColName = "the_geom";
    public static final String origGeoColName = "the_geom_orig_prop";
    public static final String crsColName = "shp_srs";
    private Schema existingSchema = null;
    private static Logger logger = Logger.getLogger((String)"dku.formats.shapefile");

    public ShapefileFormatExtractor(Config params) {
        this.params = params;
    }

    public ShapefileFormatExtractor() {
        this.params = new Config();
    }

    @Override
    public void setLimit(ExtractionLimit limit) {
        this.limit = limit;
    }

    @Override
    public void setSchema(Schema schema, boolean allowExtraColumns) {
        this.existingSchema = schema;
    }

    @Override
    public boolean canSetSchemaForExtractor() {
        return false;
    }

    @Override
    public void setProgressListener(InputSplitProgressListener listener) {
    }

    @Override
    public void setWarningsContext(WarningsContext warnContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSHP(File f, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        logger.info((Object)("Handling shapefile: " + f.getAbsolutePath()));
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("url", f.toURI().toURL());
        DataStore dataStore = DataStoreFinder.getDataStore(map);
        try {
            String typeName = dataStore.getTypeNames()[0];
            SimpleFeatureSource source = dataStore.getFeatureSource(typeName);
            String crs = null;
            MathTransform transform = null;
            try (FeatureIterator it = source.getFeatures().features();){
                while (true) {
                    if (!it.hasNext()) break;
                    Row row = rf.row();
                    SimpleFeature feat = (SimpleFeature)it.next();
                    if (crs == null) {
                        crs = feat.getFeatureType().getCoordinateReferenceSystem() != null ? CRS.lookupIdentifier((IdentifiedObject)feat.getFeatureType().getCoordinateReferenceSystem(), (boolean)true) : "EPSG:4326";
                        if (StringUtils.isBlank((String)crs)) {
                            crs = feat.getFeatureType().getCoordinateReferenceSystem().toWKT();
                        }
                        if (this.params.convertToWGS84) {
                            CoordinateReferenceSystem fromCRS = null;
                            fromCRS = crs.contains("PROJCS[") ? CRS.parseWKT((String)crs) : CRS.decode((String)crs, (boolean)true);
                            CoordinateReferenceSystem toCRS = CRS.decode((String)"EPSG:4326", (boolean)true);
                            transform = CRS.findMathTransform((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)toCRS, (boolean)true);
                        }
                    }
                    Geometry featGeom = (Geometry)feat.getDefaultGeometry();
                    if (this.existingSchema != null) {
                        for (SchemaColumn existingCol : this.existingSchema.columns) {
                            Property prop;
                            if (existingCol.getName().equals(geoColName)) {
                                if (featGeom == null) continue;
                                if (transform == null) {
                                    row.put(cf.column(geoColName), featGeom.toString());
                                    continue;
                                }
                                row.put(cf.column(geoColName), JTS.transform((Geometry)featGeom, (MathTransform)transform).toString());
                                continue;
                            }
                            if (existingCol.getName().equals(crsColName)) {
                                row.put(cf.column(crsColName), crs);
                                continue;
                            }
                            String lookup = existingCol.getName();
                            if (lookup.equals(origGeoColName)) {
                                lookup = geoColName;
                            }
                            if ((prop = feat.getProperty(lookup)) == null || prop.getValue() == null) continue;
                            row.put(cf.column(existingCol.getName()), prop.getValue().toString());
                        }
                    } else {
                        if (transform == null) {
                            row.put(cf.column(geoColName), featGeom.toString());
                        } else {
                            row.put(cf.column(geoColName), JTS.transform((Geometry)featGeom, transform).toString());
                        }
                        row.put(cf.column(crsColName), crs);
                        for (Property prop : feat.getProperties()) {
                            if (prop == null || prop.getValue() == null) continue;
                            String name = prop.getName().toString();
                            if (geoColName.equals(name)) {
                                if (!this.params.extractOriginalGeometryProperty) continue;
                                name = origGeoColName;
                            }
                            row.put(cf.column(name), prop.getValue().toString());
                        }
                    }
                    out.emitRow(row);
                    ++this.extractedRows;
                    if (this.limit == null || this.limit.maxRecords <= 0L || (long)this.extractedRows <= this.limit.maxRecords) continue;
                    logger.info((Object)"limit reached");
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean run(StreamsInputSplit in, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        while (true) lbl-1000:
        // 6 sources

        {
            if ((stream = in.nextStream()) == null) {
                ShapefileFormatExtractor.logger.info((Object)"Done");
                return true;
            }
            ShapefileFormatExtractor.logger.info((Object)("Try to handle: " + stream.desc()));
            if (!(stream instanceof LocalFSProvider.FileEnrichedInputStream)) {
                throw ErrorContext.iae((String)("Shapefiles are not supported on non-filesystem datasets, got: " + String.valueOf(stream.getClass())));
            }
            fistream = (LocalFSProvider.FileEnrichedInputStream)stream;
            if (fistream.getFile().getAbsolutePath().toLowerCase().endsWith(".shp")) {
                try {
                    if (this.handleSHP(fistream.getFile(), out, cf, rf)) continue;
                    return false;
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new IllegalArgumentException("You need to install the Vecmath library to open this Shapefile. Please see DSS doc: https://doc.dataiku.com/dss/latest/formats/shapefile.html", ncdfe);
                }
            }
            if (fistream.getFile().getAbsolutePath().toLowerCase().endsWith("shp.zip")) {
                tmpFolder = FlowJobUtils.getTmpFolder("shapefile-extract", "unzip-" + fistream.getFilename());
                try {
                    ZipUnzipDir.extractFolder(fistream.getFile(), (File)tmpFolder);
                    foundSHP = false;
                    for (File unzipped : tmpFolder.listFiles()) {
                        if (!unzipped.getName().toLowerCase().endsWith(".shp")) continue;
                        foundSHP = true;
                        try {
                            if (this.handleSHP(unzipped, out, cf, rf)) continue;
                            var13_14 = false;
                            return var13_14;
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            throw new IllegalArgumentException("You need to install the Vecmath library to open this Shapefile. Please see DSS doc: https://doc.dataiku.com/dss/latest/formats/shapefile.html", ncdfe);
                        }
                    }
                    if (foundSHP) ** GOTO lbl-1000
                    ShapefileFormatExtractor.logger.error((Object)"No shapefile found in zip !");
                }
                finally {
                    DKUFileUtils.deleteDirectory((File)tmpFolder);
                }
                continue;
            }
            ShapefileFormatExtractor.logger.info((Object)("Not a shapefile " + String.valueOf(fistream.getFile())));
        }
    }

    public static class Config
    implements FormatParams {
        public boolean convertToWGS84 = true;
        public boolean extractOriginalGeometryProperty = false;
        public String stringCRS = "EPSG:4326";
    }
}

