/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import org.springframework.util.StringUtils;

public class GraphicsExportUtils {
    public static File makeUniqueFile(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
        if (file.exists()) {
            File newFile;
            String extension;
            String baseName;
            String fileName = file.getName();
            int extensionIndex = fileName.lastIndexOf(46);
            if (extensionIndex >= 0) {
                baseName = fileName.substring(0, extensionIndex);
                extension = fileName.substring(extensionIndex);
            } else {
                baseName = fileName;
                extension = "";
            }
            int index = 1;
            do {
                newFile = new File(file.getParentFile(), baseName + "-" + index + extension);
                ++index;
            } while (newFile.exists());
            return newFile;
        }
        return file;
    }

    public static String sanitize(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.trimTrailingCharacter((String)str.replace(" ", "-").replaceAll("[^A-z0-9\\-_\\.]", "_"), (char)'_');
    }

    public static String getFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex < 0) {
            return "";
        }
        return filename.substring(dotIndex);
    }

    public static List<File> listFiles(File directory, FilenameFilter filter) {
        return GraphicsExportUtils.toImmutableList(directory.listFiles(filter));
    }

    private static List<File> toImmutableList(File[] files) {
        if (files == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])files);
    }

    private GraphicsExportUtils() {
    }
}

