/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.hadoop.HDFSPathUtils;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveMetadataTools;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogInternalDB;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogPartition;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogTable;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.intercom.t.PermissionsIntercomController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DSSCatalogHiveMetastoreSynchronizer
extends HiveMetastoreSynchronizer {
    @Autowired
    private DSSHiveCatalogInternalDB db;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.hive.synchro");
    private final AuthCtx authCtx;

    public DSSCatalogHiveMetastoreSynchronizer(AuthCtx authCtx) throws IOException, DKUSecurityException {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InfoMessage.InfoMessages synchronizeOneDataset(Dataset ds, boolean simulate, boolean forceDrop, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        Object tableLock;
        Object object = tableLock = DSSCatalogHiveMetastoreSynchronizer.getTableLock(ds.getFullName());
        synchronized (object) {
            return this.synchronizeOneDataset_locked(ds, simulate, forceDrop, reason, warningsContext, lenient);
        }
    }

    public InfoMessage.InfoMessages synchronizeOneDataset_locked(Dataset ds, boolean simulate, boolean forceDrop, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        return this.fullSynchronizeDataset(ds);
    }

    private InfoMessage.InfoMessages fullSynchronizeDataset(Dataset ds) throws Exception {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, ds);){
            MetastoreSynchronizationUtils.SynchronizationRequestedStatus requestedStatus = MetastoreSynchronizationUtils.synchronizationRequested(this.authCtx, ds);
            if (!requestedStatus.requested) {
                logger.info((Object)("Synchronization not requested, doing nothing (" + requestedStatus.reason + ")"));
                messages.withWarning((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_TABLE_NOT_SYNCHRONIZED, requestedStatus.reason + ", doing nothing");
                InfoMessage.InfoMessages infoMessages = messages;
                return infoMessages;
            }
            this.checkCanBeRepresented(ds);
            DSSHiveCatalogTable table = this.getTableDef(ds);
            String existingTableProjectKey = this.db.getProjectKeyOfTableOrNull(table.dbName, table.tableName);
            if (StringUtils.isNotBlank((String)existingTableProjectKey)) {
                logger.info((Object)("Table with same db.name exists in project " + existingTableProjectKey + ", checking accessibility"));
                this.checkAccessToProjectKey_autoTxn(ds.getProjectKey(), existingTableProjectKey);
            }
            ArrayList hivePartitions = null;
            if (ds.getPartitioningSchema().isPartitioned()) {
                hivePartitions = Lists.newArrayList();
                try {
                    List<FilePartition> partitions = FilePartitioner.listPartitions(this.authCtx, ds);
                    assert (partitions != null);
                    for (Partition partition : partitions) {
                        DSSHiveCatalogPartition hivePartition = this.catalogPartitionForPartition(handler, partition);
                        hivePartitions.add(hivePartition);
                    }
                }
                catch (DataStoreIOException e) {
                    if (e.getCode() == FSProviderCodes.ERR_FSPROVIDER_ROOT_PATH_DOES_NOT_EXIST) {
                        logger.info((Object)"Dataset root path does not exist, not adding partitions");
                        messages.withWarning((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_TABLE_NOT_SYNCHRONIZED, "Dataset root path does not exist, not adding partitions");
                    }
                    throw e;
                }
            }
            this.db.replaceTableWithPartitions(table, hivePartitions);
        }
        return messages;
    }

    private DSSHiveCatalogPartition catalogPartitionForPartition(MetastoreAwareDatasetHandler handler, Partition p) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        DSSHiveCatalogPartition hivePartition = new DSSHiveCatalogPartition();
        hivePartition.partitionId = p.id();
        hivePartition.hivePartitionName = HiveMetadataTools.getUnescapedHivePartitionName(p);
        HDFSableDatasetHandler hdfsAbleHandler = (HDFSableDatasetHandler)handler;
        hivePartition.location = HDFSPathUtils.concat(hdfsAbleHandler.getFullyQualifiedRootPath(), FilePartitioner.computePartitionRelPathAsFolder(p, handler.getDataset().getPartitioningSchema()));
        return hivePartition;
    }

    @Override
    public void dropExternalTable(Dataset ds) throws Exception {
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
        this.checkAccessToProjectKey_autoTxn(ds.getProjectKey(), this.db.getProjectKeyOfTableOrNull(tableRef.getSchemaNullIfBlank(), tableRef.getTable()));
        this.db.dropTable(tableRef.getSchemaNullIfBlank(), tableRef.getTable());
        this.db.dropAllPartitions(tableRef.getSchemaNullIfBlank(), tableRef.getTable());
    }

    @Override
    public void dropTableIfExists(Dataset ds) throws Exception {
        this.dropExternalTable(ds);
    }

    @Override
    public void dropPartitionIfExistsNoFail(Dataset ds, Partition partition) throws Exception {
        logger.infoV("Dropping partition if exists dataset=%s partition=%s", new Object[]{ds.getFullName(), partition});
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
        this.checkAccessToProjectKey_autoTxn(ds.getProjectKey(), this.db.getProjectKeyOfTableOrNull(tableRef.getSchemaNullIfBlank(), tableRef.getTable()));
        this.db.dropPartitionByDSSPartitionId(tableRef.getSchemaNullIfBlank(), tableRef.getTable(), partition.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeOneDatasetPartition(Dataset dataset, Partition partition, boolean simulate, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        Object tableLock;
        Object object = tableLock = DSSCatalogHiveMetastoreSynchronizer.getTableLock(dataset.getFullName());
        synchronized (object) {
            this.synchronizeOneDatasetPartition_locked(dataset, partition, simulate, reason, warningsContext, lenient);
        }
    }

    private void synchronizeOneDatasetPartition_locked(Dataset dataset, Partition partition, boolean simulate, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            if (!MetastoreSynchronizationUtils.synchronizationRequested((AuthCtx)this.authCtx, (Dataset)dataset).requested) {
                return;
            }
            this.checkCanBeRepresented(dataset);
            HiveSchemaCompatibility schemaCompatibility = this.isExistingSchemaCompatible(dataset);
            if (schemaCompatibility.schemaCompatible) {
                logger.info((Object)"Hive schema is up to date: (re)synchronizing a single partition");
                DSSHiveCatalogTable table = this.getTableDef(dataset);
                if (partition != null && dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned()) {
                    if (partition.isAll()) {
                        List<FilePartition> partitions = FilePartitioner.listPartitions(this.authCtx, dataset);
                        assert (partitions != null);
                        ArrayList hivePartitions = Lists.newArrayList();
                        for (Partition partition2 : partitions) {
                            DSSHiveCatalogPartition hivePartition = this.catalogPartitionForPartition(handler, partition2);
                            hivePartitions.add(hivePartition);
                        }
                        this.db.replaceTableWithPartitions(table, hivePartitions);
                    } else {
                        DSSHiveCatalogPartition hivePartition = null;
                        hivePartition = this.catalogPartitionForPartition(handler, partition);
                        this.db.updateTableWithPartition(table, hivePartition);
                    }
                }
                return;
            }
            logger.info((Object)"Hive schema is not up to date: (re)synchronize the whole table");
            this.fullSynchronizeDataset(dataset);
        }
    }

    public HiveSchemaCompatibility isExistingSchemaCompatible(Dataset dataset) throws Exception {
        HiveSchemaCompatibility ret = new HiveSchemaCompatibility();
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
        DSSHiveCatalogTable table = null;
        try {
            table = this.db.getTable(tableRef.getSchemaNullIfBlank(), tableRef.getTable());
        }
        catch (NotFoundException e) {
            return ret;
        }
        this.checkAccessToProjectKey_autoTxn(dataset.getProjectKey(), table.projectKey);
        ret.tableExists = true;
        if (table.sd.columns.size() != dataset.getSchema().getColumns().size()) {
            logger.info((Object)"Nb columns mismatch");
            return ret;
        }
        for (int i = 0; i < table.sd.columns.size(); ++i) {
            SchemaColumn dbColumn = table.sd.columns.get(i);
            SchemaColumn datasetColumn = (SchemaColumn)dataset.getSchema().getColumns().get(i);
            if (!StringUtils.equalsIgnoreCase((String)dbColumn.getName(), (String)datasetColumn.getName())) {
                logger.info((Object)"column name mismatch");
                return ret;
            }
            if (datasetColumn.getType() == dbColumn.getType()) continue;
            logger.info((Object)"column type mismatch");
            return ret;
        }
        ret.schemaCompatible = true;
        return ret;
    }

    private void checkCanBeRepresented(Dataset dataset) {
        boolean rep;
        if (dataset.getPartitioningSchema().isPartitioned() && !(rep = FilePartitioner.isSchemeRepresentableAsFolder(dataset.getPartitioningSchema()))) {
            throw ErrorContext.iaef((String)"Dataset %s cannot be represented in Hive: partition does not map to a folder", (Object)dataset.getFullName(), (Object[])new Object[0]);
        }
    }

    private DSSHiveCatalogTable getTableDef(Dataset dataset) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            HDFSableDatasetHandler hdfsAbleHandler = (HDFSableDatasetHandler)handler;
            SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
            DSSHiveCatalogTable table = new DSSHiveCatalogTable();
            table.projectKey = dataset.getProjectKey();
            table.datasetName = dataset.getName();
            table.dbName = tableRef.getSchemaNullIfBlank();
            table.tableName = tableRef.getTable();
            DSSHiveCatalogTable.DSSHiveCatalogTableStorageDescriptor sd = new DSSHiveCatalogTable.DSSHiveCatalogTableStorageDescriptor();
            sd.columns = dataset.getSchema().getColumns();
            sd.location = hdfsAbleHandler.getFullyQualifiedRootPath();
            HiveSchemaHandler.HiveRowFormatInfo dssSd = HiveSchemaHandler.getRowFormat(dataset, dataset.getName(), MetastoreInspectionService.MetastoreKind.DSS);
            sd.inputFormat = dssSd.inputFormat;
            sd.outputFormat = dssSd.outputFormat;
            sd.serdeName = dssSd.serializationLib;
            sd.serdeParams.putAll(dssSd.storageParams);
            sd.serdeParams.putAll(dssSd.serdeParams);
            sd.serdeParams.putAll(HiveSchemaHandler.getTablePropertiesMap(this.authCtx, dataset, false));
            if (dataset.getPartitioningSchema().isPartitioned()) {
                table.partitionKeys = new ArrayList<SchemaColumn>();
                for (String dim : dataset.getPartitioningSchema().getDimensionNames()) {
                    table.partitionKeys.add(new SchemaColumn(dim, Type.STRING));
                }
            }
            table.sd = sd;
            DSSHiveCatalogTable dSSHiveCatalogTable = table;
            return dSSHiveCatalogTable;
        }
    }

    private boolean hasAccessToProjectKey_autoTxn(String projectKey) throws DKUSecurityException, IOException {
        boolean hasProjectPrivilege;
        switch (ClusterSelector.getContext()) {
            case APIMAIN: 
            case BACKEND: {
                IPermissionsService permissionsService = (IPermissionsService)SpringUtils.getBean(IPermissionsService.class);
                if (TransactionContext.hasAttachedTransaction()) {
                    hasProjectPrivilege = permissionsService.hasProjectPrivilege(this.authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                    break;
                }
                TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                try (Transaction t = transactionService.beginRead();){
                    hasProjectPrivilege = permissionsService.hasProjectPrivilege(this.authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                    break;
                }
            }
            case CDE: {
                throw new UnsupportedOperationException("Cannot access the DSS-as-Hive metastore from containerized jobs");
            }
            case DKU: 
            case JEK: {
                APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                     TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
                    hasProjectPrivilege = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/tintercom/permissions/has-project-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"projectKey", projectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()})).ok;
                    break;
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case CAK: 
            case FEK: {
                int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                try (LocalPrivilegedIntercomAPIClient apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);){
                    hasProjectPrivilege = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/intercom/permissions/has-project-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"authCtx", JSON.json((Object)this.authCtx), "projectKey", projectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()})).ok;
                    break;
                }
            }
            default: {
                throw new Error("DSS Process type not set, cannot check cluster access");
            }
        }
        return hasProjectPrivilege;
    }

    private void checkAccessToProjectKey_autoTxn(String projectKey, String tableProjectKey) throws DKUSecurityException, IOException {
        if (tableProjectKey != null && !StringUtils.equals((String)tableProjectKey, (String)projectKey) && !this.hasAccessToProjectKey_autoTxn(tableProjectKey)) {
            throw new DKUSecurityException("Existing table is in project " + projectKey + ", cannot access");
        }
    }

    public static class HiveSchemaCompatibility {
        public boolean unknown;
        public boolean tableExists;
        public boolean schemaCompatible;
    }
}

