/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.parquet.NanoTimeUtils;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ReusableParquetRow;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.Days;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.parquet.io.api.Binary;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParquetRowBuilder {
    private Set<ParquetFormatConfig.Flavor> hiveLikeFlavors = Sets.newHashSet((Object[])new ParquetFormatConfig.Flavor[]{ParquetFormatConfig.Flavor.HIVE, ParquetFormatConfig.Flavor.SPARK});
    private static final Boolean booleanMeaning = new Boolean();
    private static final DateTimeFormatter isoParser = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
    private final ColumnFactory columnFactory;
    private final ArrayList<Column> columns;
    private final boolean lowerCaseIdentifiers;
    private final ParquetFormatConfig.Flavor flavor;
    private final List<SchemaColumn> schemaColumns;

    public ParquetRowBuilder(Schema schema, ColumnFactory cf, boolean lowerCaseIdentifiers, ParquetFormatConfig.Flavor flavor) {
        this.columnFactory = (ColumnFactory)Preconditions.checkNotNull((Object)cf);
        this.flavor = (ParquetFormatConfig.Flavor)((Object)Preconditions.checkNotNull((Object)((Object)flavor)));
        this.schemaColumns = (List)Preconditions.checkNotNull((Object)((Schema)Preconditions.checkNotNull((Object)schema)).getColumns());
        this.lowerCaseIdentifiers = lowerCaseIdentifiers;
        this.columns = new ArrayList();
        for (SchemaColumn sc : this.schemaColumns) {
            this.columns.add(this.columnFactory.column(sc.getName()));
        }
    }

    public void build(Row row, ReusableParquetRow rc) throws IOException {
        rc.clear();
        rc.startMessage();
        for (int i = 0; i < this.columns.size(); ++i) {
            SchemaColumn dssCol;
            String val = row.get(this.columns.get(i));
            String fieldName = this.columns.get(i).getName();
            if (this.lowerCaseIdentifiers) {
                fieldName = fieldName.toLowerCase();
            }
            if (!(dssCol = this.schemaColumns.get(i)).getType().isPrimitive() && StringUtils.equalsIgnoreCase((String)val, (String)"null")) {
                val = null;
            }
            try {
                this.writeField(rc, fieldName, i, dssCol, val);
                continue;
            }
            catch (Exception e) {
                throw new IOException("Failed to write in column " + fieldName + " (content:" + val + "): " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        rc.endMessage();
    }

    private void writeHiveDate(ReusableParquetRow rc, SchemaColumn dssCol, String data) {
        DateTime parsed = isoParser.parseDateTime(data);
        Timestamp ts = new Timestamp(parsed.getMillis());
        NanoTimeUtils.getNanoTime(ts).writeValue(rc);
    }

    private void writeDatetimeNoTz(ReusableParquetRow rc, SchemaColumn dssCol, String data) {
        if (data != null && data.contains("T")) {
            DateTime parsed = isoParser.parseDateTime(data);
            long ts = parsed.getMillis();
            rc.addLong(ts);
        } else {
            LocalDateTime parsed = DatetimeNoTz.FORMATTER.parseLocalDateTime(data);
            long ts = parsed.toDateTime(DateTimeZone.UTC).getMillis();
            rc.addLong(ts);
        }
    }

    private void writeDateOnly(ReusableParquetRow rc, SchemaColumn dssCol, String data) {
        LocalDate parsed = DateOnly.FORMATTER.parseLocalDate(data);
        rc.addInteger(Days.daysBetween((ReadablePartial)new LocalDate(0L), (ReadablePartial)parsed).getDays());
    }

    private void writeField(ReusableParquetRow rc, String fieldName, int fieldIdx, SchemaColumn dssCol, String data) throws JSONException {
        switch (dssCol.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                rc.addInteger(Integer.parseInt(data));
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case BIGINT: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                rc.addLong(Long.parseLong(data));
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case FLOAT: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                rc.addFloat(Float.parseFloat(data));
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case DOUBLE: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                rc.addDouble(Double.parseDouble(data));
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case BOOLEAN: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                rc.addBoolean(booleanMeaning.parse(data));
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case STRING: {
                if (data == null) break;
                rc.startField(fieldName, fieldIdx);
                if (data.length() == 0) {
                    rc.addBinary(Binary.EMPTY);
                } else {
                    rc.addBinary(Binary.fromByteArray((byte[])data.getBytes(StandardCharsets.UTF_8)));
                }
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case DATE: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                this.writeHiveDate(rc, dssCol, data);
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case DATETIMENOTZ: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                this.writeDatetimeNoTz(rc, dssCol, data);
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case DATEONLY: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                this.writeDateOnly(rc, dssCol, data);
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case ARRAY: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                this.writeArray(rc, dssCol, new JSONArray(data));
                rc.endField(fieldName, fieldIdx);
                break;
            }
            case MAP: {
                this.writeMapField(rc, fieldName, fieldIdx, dssCol, data);
                break;
            }
            case OBJECT: {
                if (StringUtils.isBlank((String)data)) break;
                rc.startField(fieldName, fieldIdx);
                this.writeObject(rc, dssCol, new JSONObject(data));
                rc.endField(fieldName, fieldIdx);
                break;
            }
            default: {
                throw new NotImplementedException(dssCol.getType().getName() + " isn't supported by Parquet output");
            }
        }
    }

    private void writeMapField(ReusableParquetRow rc, String fieldName, int fieldIdx, SchemaColumn dssCol, String data) throws JSONException {
        JSONObject parsedMap;
        if (!(StringUtils.isBlank((String)data) || !(parsedMap = new JSONObject(data)).keys().hasNext() && this.hiveLikeFlavors.contains((Object)this.flavor))) {
            rc.startField(fieldName, fieldIdx);
            this.writeMap(rc, dssCol, parsedMap);
            rc.endField(fieldName, fieldIdx);
        }
    }

    private void writeArray(ReusableParquetRow rc, SchemaColumn dssCol, JSONArray data) throws JSONException {
        switch (this.flavor) {
            case SPARK: 
            case HIVE: {
                this.writeHiveArray(rc, dssCol, data);
                break;
            }
            case PIG: {
                this.writePigArray(rc, dssCol, data);
                break;
            }
            default: {
                throw new NotImplementedException("Unsupported Parquet flavor " + String.valueOf((Object)this.flavor));
            }
        }
    }

    private void writePigArray(ReusableParquetRow rc, SchemaColumn dssCol, JSONArray data) throws JSONException {
        rc.startGroup();
        boolean fieldStarted = false;
        for (int i = 0; i < data.length(); ++i) {
            String objAsString;
            if (dssCol.arrayContent.getType() != Type.OBJECT) {
                throw new NotImplementedException("Parquet Pig flavor only supports bag of tuples.");
            }
            if (data.isNull(i)) continue;
            Object so = data.get(i);
            String string = objAsString = so == null ? null : so.toString();
            if (StringUtils.isBlank((String)objAsString)) continue;
            if (!fieldStarted) {
                rc.startField("bag", 0);
                fieldStarted = true;
            }
            this.writeObject(rc, dssCol.arrayContent, new JSONObject(objAsString));
        }
        if (fieldStarted) {
            rc.endField("bag", 0);
        }
        rc.endGroup();
    }

    private void writeHiveArray(ReusableParquetRow rc, SchemaColumn dssCol, JSONArray data) throws JSONException {
        rc.startGroup();
        if (data.length() > 0) {
            rc.startField("bag", 0);
            for (int i = 0; i < data.length(); ++i) {
                rc.startGroup();
                if (!data.isNull(i)) {
                    String objAsString;
                    Object so = data.get(i);
                    String string = objAsString = so == null ? null : so.toString();
                    if (!StringUtils.isBlank((String)objAsString)) {
                        this.writeField(rc, "array_element", 0, dssCol.arrayContent, objAsString);
                    }
                }
                rc.endGroup();
            }
            rc.endField("bag", 0);
        }
        rc.endGroup();
    }

    private void writeObject(ReusableParquetRow rc, SchemaColumn dssCol, JSONObject data) throws JSONException {
        rc.startGroup();
        int pos = 0;
        for (SchemaColumn sc : dssCol.objectFields) {
            String fieldName = sc.getName();
            if (this.lowerCaseIdentifiers) {
                fieldName = fieldName.toLowerCase();
            }
            if (data.has(sc.getName()) && !data.isNull(sc.getName())) {
                Object ov = data.get(sc.getName());
                String content = ov == null ? null : ov.toString();
                this.writeField(rc, fieldName, pos, sc, content);
            } else {
                this.writeField(rc, fieldName, pos, sc, null);
            }
            ++pos;
        }
        rc.endGroup();
    }

    private void writeMap(ReusableParquetRow rc, SchemaColumn dssCol, JSONObject data) throws JSONException {
        rc.startGroup();
        Iterator it = data.keys();
        if (it.hasNext()) {
            rc.startField("map", 0);
            while (it.hasNext()) {
                String k = (String)it.next();
                rc.startGroup();
                this.writeField(rc, "key", 0, dssCol.mapKeys, k);
                if (!data.isNull(k)) {
                    Object ov = data.get(k);
                    String v = ov == null ? null : ov.toString();
                    this.writeField(rc, "value", 1, dssCol.mapValues, v);
                }
                rc.endGroup();
            }
            rc.endField("map", 0);
        }
        rc.endGroup();
    }
}

