/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.im;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.AbstractHttpIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.IntegrationDirectUseEvent;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.integrations.im.AbstractSlackIntegrationParams;
import com.dataiku.dip.notifications.DefaultEventMessageBuilder;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertEvent;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.google.api.client.repackaged.com.google.common.base.Objects;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class SlackIntegrationHandler
extends AbstractHttpIntegrationEventHandler {
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        public Class<? extends IntegrationChannelParams> paramsClass() {
            return SlackChannelParams.class;
        }

        public String getType() {
            return "slack";
        }

        public String getAssociatedIntegrationType() {
            return "slack-scenario";
        }
    };
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "slack-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return AbstractSlackIntegrationParams.SlackScenarioIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new SlackIntegrationHandler(authCtx, messaging.getConfigurationAs(AbstractSlackIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(AbstractSlackIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    public static final IntegrationMeta PROJECT_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "slack-project";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return AbstractSlackIntegrationParams.SlackProjectIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new SlackIntegrationHandler(authCtx, messaging.getConfigurationAs(AbstractSlackIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(AbstractSlackIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    public static final IntegrationMeta DIRECT_USE_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "slack-direct";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return AbstractSlackIntegrationParams.SlackFreeFormIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new SlackIntegrationHandler(authCtx, messaging.getConfigurationAs(AbstractSlackIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(AbstractSlackIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    public static final IntegrationMeta UNIFIED_MONITORING_ALERTING_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "slack-unified-monitoring-alerting";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return AbstractSlackIntegrationParams.SlackUnifiedMonitoringAlertingIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new SlackIntegrationHandler(authCtx, messaging.getConfigurationAs(AbstractSlackIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(AbstractSlackIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    private final AbstractSlackIntegrationParams params;
    private final SlackChannelParams channelParams;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IntegrationChannelsDAO channelsDao;
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private IntegrationChannelPermissionsService integrationChannelPermissionsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sender.slack");

    public SlackIntegrationHandler(AuthCtx authCtx, AbstractSlackIntegrationParams params, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
        SpringUtils.getInstance().autowire((Object)this);
        this.params = params;
        if (params.useGlobalChannel()) {
            IntegrationChannel channel;
            try (Transaction t = this.transactionService.beginRead();){
                channel = this.channelsDao.getMandatory(params.channelId);
            }
            if (permissionCheckContext.checkCanUseIntegrationChannel) {
                this.integrationChannelPermissionsService.checkIntegrationChannelUse(authCtx, channel);
            }
            this.channelParams = (SlackChannelParams)channel.getConfigurationAs(SlackChannelParams.class);
        } else {
            this.channelParams = new SlackChannelParams();
            this.channelParams.authorizationToken = params.authorizationToken;
            this.channelParams.channel = params.channel;
            this.channelParams.useProxy = params.useProxy;
            this.channelParams.mode = params.mode;
            this.channelParams.webhookUrl = params.webhookUrl;
        }
        this.channelParams.authorizationToken = this.cryptoService.decryptIfEncrypted(this.channelParams.authorizationToken);
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        if (event instanceof IntegrationDirectUseEvent) {
            IntegrationDirectUseEvent sevent = (IntegrationDirectUseEvent)event;
            AbstractSlackIntegrationParams.SlackFreeFormIntegrationParams sconf = (AbstractSlackIntegrationParams.SlackFreeFormIntegrationParams)this.params;
            String message = (String)Objects.firstNonNull((Object)sconf.message, (Object)"${message}");
            StrSubstitutor substitutor = new StrSubstitutor((StrLookup)sevent.lookup);
            SlackRequest request = new SlackRequest();
            request.useProxy = this.channelParams.useProxy;
            request.mode = this.channelParams.mode;
            request.channel = substitutor.replace(this.channelParams.channel);
            request.iconEmoji = substitutor.replace(this.params.iconEmoji);
            request.iconUrl = substitutor.replace(this.params.iconUrl);
            request.webhookUrl = substitutor.replace(this.channelParams.webhookUrl);
            request.authorizationToken = substitutor.replace(this.channelParams.authorizationToken);
            request.userName = substitutor.replace(sconf.username);
            request.asUser = sconf.asUser;
            request.linkNames = sconf.linkNames;
            request.message = substitutor.replace(message);
            request.useBlocks = SlackMessageMode.BLOCK_KIT_API.equals((Object)sconf.messageMode);
            request.blocks = substitutor.replace(sconf.blocks);
            this.send(request);
        } else if (event instanceof ScenarioReportEvent) {
            ScenarioReportEvent sevent = (ScenarioReportEvent)event;
            AbstractSlackIntegrationParams.SlackScenarioIntegrationParams sconf = (AbstractSlackIntegrationParams.SlackScenarioIntegrationParams)this.params;
            StrSubstitutor substitutor = new StrSubstitutor((StrLookup)sevent.lookup);
            this.send(sconf.username, sconf.asUser, sconf.linkNames, substitutor.replace(sconf.message), SlackMessageMode.BLOCK_KIT_API.equals((Object)sconf.messageMode), substitutor.replace(sconf.blocks));
        } else if (event instanceof UnifiedMonitoringAlertEvent) {
            UnifiedMonitoringAlertEvent umevent = (UnifiedMonitoringAlertEvent)event;
            AbstractSlackIntegrationParams.SlackUnifiedMonitoringAlertingIntegrationParams umconf = (AbstractSlackIntegrationParams.SlackUnifiedMonitoringAlertingIntegrationParams)this.params;
            StrSubstitutor substitutor = new StrSubstitutor((StrLookup)umevent.lookup);
            this.send(umconf.username, umconf.asUser, umconf.linkNames, substitutor.replace(umconf.message), SlackMessageMode.BLOCK_KIT_API.equals((Object)umconf.messageMode), substitutor.replace(umconf.blocks));
        } else {
            AbstractSlackIntegrationParams.SlackProjectIntegrationParams pconf = (AbstractSlackIntegrationParams.SlackProjectIntegrationParams)this.params;
            if (!pconf.selection.shouldSend(event)) {
                return;
            }
            String msg = new DefaultEventMessageBuilder().build(event, Markup.SLACK_MARKDOWN);
            msg = this.markdownify(msg);
            this.send(pconf.username, pconf.asUser, pconf.linkNames, msg, false, "");
        }
    }

    private String markdownify(String msg) {
        return msg.replaceAll("<a\\s(?!</a)href=\"([^\"]*)\"\\s*>([^<]*)</a\\s*>", "<$1|$2>").replaceAll("<br\\s*/>", "\n");
    }

    private void send(String userName, boolean asUser, boolean linkNames, String message, boolean useBlocks, String blocks) throws IOException {
        SlackRequest request = new SlackRequest();
        request.useProxy = this.channelParams.useProxy;
        request.mode = this.channelParams.mode;
        request.channel = this.channelParams.channel;
        request.iconEmoji = this.params.iconEmoji;
        request.iconUrl = this.params.iconUrl;
        request.webhookUrl = this.channelParams.webhookUrl;
        request.authorizationToken = this.channelParams.authorizationToken;
        request.userName = userName;
        request.asUser = asUser;
        request.linkNames = linkNames;
        request.message = message;
        request.useBlocks = useBlocks;
        request.blocks = blocks;
        this.send(request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void send(SlackRequest request) throws IOException {
        if (request.mode == SlackMode.WEBHOOK) {
            if (StringUtils.isBlank((String)request.webhookUrl)) {
                throw new IllegalArgumentException("Webhook url not defined");
            }
            JsonObject payload = new JsonObject();
            if (request.useBlocks) {
                payload.addProperty("blocks", request.blocks);
            } else {
                payload.addProperty("text", request.message);
            }
            if (StringUtils.isNotBlank((String)request.userName)) {
                payload.addProperty("username", request.userName);
            }
            if (StringUtils.isNotBlank((String)request.channel)) {
                payload.addProperty("channel", request.channel);
            }
            if (StringUtils.isNotBlank((String)request.iconEmoji)) {
                payload.addProperty("icon_emoji", request.iconEmoji);
            }
            if (StringUtils.isNotBlank((String)request.iconUrl)) {
                payload.addProperty("icon_url", request.iconUrl);
            }
            String json = JSON.json((Object)payload);
            logger.info((Object)("Posting slack message via Webhook: " + json));
            AbstractHttpIntegrationEventHandler.RequestResponse response = this.postJsonRequest(request.webhookUrl, request.useProxy, json, NO_AUTH);
            if (!response.isSuccess()) {
                throw new IOException("API call to post message on Slack failed : " + response.statusCode + " with reason " + response.statusReason);
            }
            logger.info((Object)("Report posted on Slack: " + response.content));
            return;
        } else {
            if (request.mode != SlackMode.API) throw new IllegalArgumentException("Mode not defined");
            ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
            postParameters.add((NameValuePair)new BasicNameValuePair("token", request.authorizationToken));
            postParameters.add((NameValuePair)new BasicNameValuePair("channel", request.channel));
            if (StringUtils.isNotBlank((String)request.userName)) {
                postParameters.add((NameValuePair)new BasicNameValuePair("username", request.userName));
            }
            if (StringUtils.isNotBlank((String)request.iconEmoji)) {
                postParameters.add((NameValuePair)new BasicNameValuePair("icon_emoji", request.iconEmoji));
            }
            if (StringUtils.isNotBlank((String)request.iconUrl)) {
                postParameters.add((NameValuePair)new BasicNameValuePair("icon_url", request.iconUrl));
            }
            if (request.asUser) {
                postParameters.add((NameValuePair)new BasicNameValuePair("as_user", String.valueOf(request.asUser)));
            }
            if (request.linkNames) {
                postParameters.add((NameValuePair)new BasicNameValuePair("link_names", "1"));
            }
            if (request.useBlocks) {
                postParameters.add((NameValuePair)new BasicNameValuePair("text", ""));
                postParameters.add((NameValuePair)new BasicNameValuePair("blocks", request.blocks));
            } else {
                postParameters.add((NameValuePair)new BasicNameValuePair("text", request.message));
            }
            AbstractHttpIntegrationEventHandler.RequestResponse response = this.postRequest("https://slack.com/api/chat.postMessage", request.useProxy, postParameters, NO_AUTH);
            if (!response.isSuccess()) {
                throw new IOException("API call to post message on Slack failed : " + response.statusCode + " with reason " + response.statusReason);
            }
            SlackResponse posted = (SlackResponse)JSON.parse((String)response.content, SlackResponse.class);
            if (posted != null) {
                if (!posted.ok) throw new IOException("Failed to post message on Slack via API, got error: " + posted.error);
                logger.info((Object)("Report posted on Slack via API at " + posted.ts));
                return;
            } else {
                logger.warn((Object)"Could not parse the response from Slack, maybe the API changed?");
            }
        }
    }

    public static class SlackChannelParams
    extends AbstractHttpIntegrationEventHandler.HTTPChannelConfiguration {
        public SlackMode mode = SlackMode.API;
        public String webhookUrl;
        public String authorizationToken;
        public String channel;

        public void encryptFields(PasswordEncryptionService cryptoService) {
            this.authorizationToken = cryptoService.encryptIfNotEncryptedOrEmpty(this.authorizationToken);
        }
    }

    public static enum SlackMode {
        WEBHOOK,
        API,
        BLOCK;

    }

    public static class SlackRequest {
        SlackMode mode;
        String userName;
        boolean asUser;
        boolean linkNames;
        String message;
        boolean useBlocks;
        String blocks;
        String channel;
        String iconEmoji;
        String iconUrl;
        String webhookUrl;
        String authorizationToken;
        boolean useProxy;
    }

    public static enum SlackMessageMode {
        TEXT_MESSAGE,
        BLOCK_KIT_API;

    }

    private static class SlackResponse {
        boolean ok;
        String ts;
        String error;

        private SlackResponse() {
        }
    }
}

