/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.custom;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.llm.custom.CustomLLMTypesRegistry;
import com.dataiku.dip.llm.custom.CustomPythonLLMDesc;
import com.dataiku.dip.llm.custom.LoadedPythonLLM;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonLLMsService
extends CustomPythonElementService<CustomPythonLLMDesc, LoadedPythonLLM> {
    @Override
    public String getFolderName() {
        return "python-llms";
    }

    @Override
    public String getPrefix() {
        return "llm";
    }

    @Override
    protected String getCodeExtension(LoadedPythonLLM desc) {
        return ".py";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "llm_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomPythonLLMDesc> getDescClass() {
        return CustomPythonLLMDesc.class;
    }

    @Override
    public Class<LoadedPythonLLM> getLoadedDescClass() {
        return LoadedPythonLLM.class;
    }

    @Override
    protected void removeElement(LoadedPythonLLM loaded) {
        FormatFactory.deregisterFormatType(loaded.getType());
    }

    @Override
    protected LoadedPythonLLM load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonLLM loaded = new LoadedPythonLLM(elementType, pluginId, elementId, (CustomPythonLLMDesc)JSON.parseFile((File)file, CustomPythonLLMDesc.class));
        CustomLLMTypesRegistry.register(loaded, this);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomPythonLLMDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonLLMsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

