/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.utils;

import com.dataiku.dip.llm.online.utils.BatchBufferProcessor;
import com.dataiku.dip.llm.online.utils.QueryProcessor;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BatchProcessor<Q, R>
implements QueryProcessor<Q, R> {
    public final int batchSize;
    private final BatchBufferProcessor<Q, R> batchBufferProcessor;
    private final Executor preProcessingExecutor;
    private final Executor postProcessingExecutor;
    private final Set<CompletableFuture<Void>> pendingBufferProcessingSubmissionFutures = ConcurrentHashMap.newKeySet();

    public BatchProcessor(@Nonnull ExecutorService executorService, int batchSize, @Nullable Executor preProcessingExecutor, @Nullable Executor postProcessingExecutor) {
        this.batchSize = batchSize;
        this.preProcessingExecutor = (Executor)MoreObjects.firstNonNull((Object)preProcessingExecutor, Runnable::run);
        this.postProcessingExecutor = (Executor)MoreObjects.firstNonNull((Object)postProcessingExecutor, Runnable::run);
        this.batchBufferProcessor = new BatchBufferProcessor(batchSize, executorService, this::processBatch);
    }

    protected abstract List<R> processBatch(List<Q> var1);

    protected Optional<R> preProcessQueryOrBypassProcessing(Q query) {
        return Optional.empty();
    }

    protected R postProcess(Q query, R result, boolean processingWasBypassed) {
        return result;
    }

    @Override
    public synchronized CompletableFuture<R> submit(Q query) {
        CompletableFuture<Void> pendingBufferSubmissionFuture = this.newPendingBufferSubmissionFuture();
        CompletableFuture<Optional> preProcessingFuture = CompletableFuture.supplyAsync(() -> this.preProcessQueryOrBypassProcessing(query), this.preProcessingExecutor);
        CompletionStage processingFuture = preProcessingFuture.thenCompose(optResult -> {
            if (optResult.isPresent()) {
                this.completePendingBufferSubmissionFuture(pendingBufferSubmissionFuture);
                return CompletableFuture.completedFuture(new ProcessingOutput(optResult.get(), true));
            }
            CompletableFuture<R> bufferProcessingFuture = this.batchBufferProcessor.submit(query);
            this.completePendingBufferSubmissionFuture(pendingBufferSubmissionFuture);
            return bufferProcessingFuture.thenApply(r -> new ProcessingOutput<Object>(r, false));
        });
        CompletionStage postProcessingFuture = ((CompletableFuture)processingFuture).thenApplyAsync(resultOutput -> this.postProcess(query, resultOutput.result, resultOutput.bypassed), this.postProcessingExecutor);
        this.ensureCleanTermination(pendingBufferSubmissionFuture, (CompletableFuture<R>)postProcessingFuture);
        return postProcessingFuture;
    }

    private CompletableFuture<Void> newPendingBufferSubmissionFuture() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.pendingBufferProcessingSubmissionFutures.add(future);
        return future;
    }

    private void completePendingBufferSubmissionFuture(CompletableFuture<Void> pendingBufferSubmissionFuture) {
        pendingBufferSubmissionFuture.complete(null);
        this.pendingBufferProcessingSubmissionFutures.remove(pendingBufferSubmissionFuture);
    }

    private void ensureCleanTermination(CompletableFuture<Void> pendingBufferSubmissionFuture, CompletableFuture<R> postProcessingFuture) {
        postProcessingFuture.whenComplete((r, e) -> {
            if (e != null) {
                this.completePendingBufferSubmissionFuture(pendingBufferSubmissionFuture);
            }
        });
    }

    public List<CompletableFuture<R>> submitAllAndFlush(List<Q> queries) {
        List<CompletableFuture<R>> futures = queries.stream().map(this::submit).collect(Collectors.toList());
        this.flush();
        return futures;
    }

    public synchronized CompletableFuture<Integer> flush() {
        return CompletableFuture.allOf(this.pendingBufferProcessingSubmissionFutures.toArray(new CompletableFuture[0])).thenApply(v -> this.batchBufferProcessor.flush());
    }

    static class ProcessingOutput<R> {
        final R result;
        final boolean bypassed;

        ProcessingOutput(R result, boolean bypassed) {
            this.result = result;
            this.bypassed = bypassed;
        }
    }
}

