/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.populardatasets.PopularDatasetsConfig;
import com.dataiku.dip.populardatasets.PopularDatasetsService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class ComputeMostUsedDatasetTask
implements Job {
    @Autowired
    private PopularDatasetsService popularDatasetsService;

    public ComputeMostUsedDatasetTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        DKULogger.startCurrentCall();
        try {
            GeneralSettingsDAO.PopularDatasetsSettings popularDatasetsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().popularDatasetsSettings;
            PopularDatasetsConfig.ProcessingOptions config = this.popularDatasetsService.getProcessingOptions(popularDatasetsSettings);
            this.popularDatasetsService.startComputation(config, DSSAuthCtx.newNone());
        }
        catch (Exception e) {
            throw new JobExecutionException("Failed to compute popular datasets", (Throwable)e);
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }
}

