/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.EmptyProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class GitGCTask
implements Job {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.maint.git");

    public GitGCTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        EmptyProgressMonitor monitor = new EmptyProgressMonitor(){

            public void endTask() {
                logger.info((Object)"End");
            }

            public void beginTask(String arg0, int arg1) {
                logger.info((Object)("Begin: " + arg0 + " (" + arg1 + ")"));
            }
        };
        if (ApplicationConfigurator.getGitMode() == DSSGitModel.GitMode.GLOBAL) {
            DKULogger.startCurrentCall();
            try {
                logger.info((Object)"Running global Git GC");
                try (ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)"Git GC");){
                    JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
                    Git git = gitManager.getSubGit((String)"null").git;
                    git.gc().setProgressMonitor((ProgressMonitor)monitor).call();
                }
                logger.info((Object)"Done global Git GC");
            }
            catch (Exception e) {
                throw new JobExecutionException("Git GC failed", (Throwable)e);
            }
            finally {
                DKULogger.endCurrentCall();
            }
            return;
        }
        List<Object> keys = new ArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            keys = this.projectsService.listProjectKeys();
        }
        catch (Exception e) {
            throw new JobExecutionException("Can't list projects for Git GC", (Throwable)e);
        }
        JobExecutionException failure = null;
        for (String string : keys) {
            JobExecutionException exc = this.projectGitGC(string);
            if (exc == null) continue;
            failure = exc;
        }
        this.globalGitGC((ProgressMonitor)monitor);
        if (failure != null) {
            throw failure;
        }
    }

    private void globalGitGC(ProgressMonitor monitor) throws JobExecutionException {
        DKULogger.startCurrentCall();
        try {
            logger.info((Object)"Running global zone Git GC");
            try (ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)"Git GC");){
                JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
                Git git = gitManager.getGlobalGit();
                git.gc().setProgressMonitor(monitor).call();
            }
            logger.info((Object)"Done global zone Git GC");
        }
        catch (Exception e) {
            throw new JobExecutionException("Git GC failed", (Throwable)e);
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobExecutionException projectGitGC(String pkey) {
        DKULogger.startCurrentCall();
        try {
            JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
            Git git = gitManager.getSubGit((String)pkey).git;
            try (ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("Git GC: " + pkey));){
                logger.infoV("Running git GC on project %s", new Object[]{pkey});
                git.gc().call();
                logger.infoV("Done git GC on project %s", new Object[]{pkey});
            }
            JobExecutionException jobExecutionException = null;
            return jobExecutionException;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to Git GC on " + pkey), (Throwable)e);
            JobExecutionException jobExecutionException = new JobExecutionException("Git GC failed for project " + pkey, (Throwable)e);
            return jobExecutionException;
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }
}

