/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.CodeProbeComputer;
import com.dataiku.dip.metrics.engines.ColumnMetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.QueryBasedProbeComputer;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class MetricComputer {
    public abstract MetricsEngineDesc getEngine();

    public abstract String getProbeType();

    public abstract MetricsEngineRun handles(AuthCtx var1, Probe var2, Metric var3, Object var4, MetricTargetType var5, Partition var6);

    public Map<String, Object> getVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        VariablesContext variablesContext = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getContext(projectKey);
        HashMap<String, Object> variables = new HashMap<String, Object>(variablesContext.getAllVariables());
        Map<String, Object> additionalVariables = this.getAdditionalVariables(probe, authCtx, projectKey);
        if (additionalVariables != null) {
            variables.putAll(additionalVariables);
        }
        return variables;
    }

    public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getEngine().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricComputer other = (MetricComputer)obj;
        return this.getEngine().equals(other.getEngine());
    }

    public static abstract class PythonEngineComputer
    extends MetricComputer
    implements CodeProbeComputer {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.PythonEngine;
        }
    }

    public static abstract class SparkQueryEngineComputer
    extends MetricComputer
    implements QueryBasedProbeComputer {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.SparkQueryEngine;
        }
    }

    public static abstract class SparkColumnMetricsEngineComputer
    extends MetricComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.SparkColumnMetricsEngine;
        }
    }

    public static abstract class SparkMetricsEngineComputer
    extends MetricComputer
    implements MetricsQueryBuilder.MetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.SparkMetricsEngine;
        }
    }

    public static abstract class ImpalaQueryEngineComputer
    extends MetricComputer
    implements QueryBasedProbeComputer {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.ImpalaQueryEngine;
        }
    }

    public static abstract class ImpalaColumnMetricsEngineComputer
    extends MetricComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.ImpalaColumnMetricsEngine;
        }
    }

    public static abstract class ImpalaMetricsEngineComputer
    extends MetricComputer
    implements MetricsQueryBuilder.MetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.ImpalaMetricsEngine;
        }
    }

    public static abstract class HiveQueryEngineComputer
    extends MetricComputer
    implements QueryBasedProbeComputer {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.HiveQueryEngine;
        }
    }

    public static abstract class HiveColumnMetricsEngineComputer
    extends MetricComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.HiveColumnMetricsEngine;
        }
    }

    public static abstract class HiveMetricsEngineComputer
    extends MetricComputer
    implements MetricsQueryBuilder.MetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.HiveMetricsEngine;
        }
    }

    public static abstract class SQLQueryEngineComputer
    extends MetricComputer
    implements QueryBasedProbeComputer {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.SQLQueryEngine;
        }
    }

    public static abstract class SQLColumnMetricsEngineComputer
    extends MetricComputer
    implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.SQLColumnMetricsEngine;
        }
    }

    public static abstract class SQLMetricsEngineComputer
    extends MetricComputer
    implements MetricsQueryBuilder.MetricsQueryBuilderAggregation {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.SQLMetricsEngine;
        }
    }

    public static abstract class DSSEngineComputer
    extends MetricComputer {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.DSSEngine;
        }
    }

    public static abstract class BasicEngineComputer
    extends MetricComputer {
        @Override
        public MetricsEngineDesc getEngine() {
            return MetricsEngineDesc.BasicEngine;
        }
    }
}

