/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.PivotAllFilteredOutException;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotTableUtils;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.sql.utils.BinUtils;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalysis;
import java.util.ArrayList;
import java.util.List;

public class NumericalFixedNbBinsAxisHandler
implements AxisHandler {
    private NumericalVariableAnalysis analysis;
    private final Column col;
    private final NumericalAxisParams params;
    int requested = -1;

    public NumericalFixedNbBinsAxisHandler(Column col, NumericalAxisParams params) {
        if (params == null) {
            params = new NumericalAxisParams();
            params.nbBins = 20;
        }
        this.params = params;
        this.col = col;
        this.analysis = new NumericalVariableAnalysis();
        this.analysis.min = Double.MAX_VALUE;
        this.analysis.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public void observe(Row row) {
        String v = row.get(this.col);
        if (v == null || v.isEmpty()) {
            return;
        }
        try {
            double d = Double.parseDouble(v);
            if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                this.onObservation(d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            double d;
            if (filters != null && !filters[i] || Double.isNaN(d = block.doubles[i]) || Double.isInfinite(d)) continue;
            this.onObservation(d);
        }
    }

    private void onObservation(double value) {
        this.analysis.min = Math.min(this.analysis.min, value);
        this.analysis.max = Math.max(this.analysis.max, value);
    }

    @Override
    public int getNbBins() {
        BinUtils.HistogramParams histogramParams = BinUtils.getHistogramParams(this.params.niceBounds, this.params.nbBins, this.analysis.min, this.analysis.max);
        this.params.nbBins = histogramParams.nbBins;
        this.analysis.histogramLowerBounds = BinUtils.buildLowerBounds(histogramParams.nbBins, histogramParams.fixedMin, histogramParams.step);
        this.analysis.histogramUpperBounds = BinUtils.buildUpperBounds(histogramParams.nbBins, histogramParams.fixedMin, histogramParams.fixedMax, histogramParams.step);
        if (this.analysis.min > this.analysis.max) {
            throw new PivotAllFilteredOutException();
        }
        return this.params.nbBins;
    }

    @Override
    public void getBins(ColumnBlock block, int[] ret, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            int bin;
            if (filters != null && !filters[i]) {
                ret[i] = -1;
                continue;
            }
            ++this.requested;
            double v = block.doubles[i];
            ret[i] = Double.isNaN(v) || Double.isInfinite(v) ? -1 : ((bin = this.findValueBin(this.analysis.histogramLowerBounds, this.analysis.histogramUpperBounds, v)) == -1 ? this.analysis.histogramLowerBounds.length - 1 : bin);
        }
    }

    private int findValueBin(double[] lowerBounds, double[] upperBounds, double value) {
        int l = 0;
        int r = lowerBounds.length - 1;
        while (l <= r) {
            int mid = l + (r - l) / 2;
            if (lowerBounds[mid] <= value && value < upperBounds[mid]) {
                return mid;
            }
            if (value < lowerBounds[mid]) {
                r = mid - 1;
                continue;
            }
            l = mid + 1;
        }
        return -1;
    }

    @Override
    public List<AxisElt> getAxisElts() {
        ArrayList<AxisElt> ret = new ArrayList<AxisElt>();
        PivotTableUtils.NumberFormatter formatter = new PivotTableUtils.NumberFormatter(this.analysis.min, this.analysis.max, this.params.nbBins, false);
        for (int i = 0; i < this.params.nbBins; ++i) {
            NumericalAxisElt elt = new NumericalAxisElt();
            elt.sortValue = (this.analysis.histogramUpperBounds[i] + this.analysis.histogramLowerBounds[i]) / 2.0;
            elt.min = this.analysis.histogramLowerBounds[i];
            elt.max = this.analysis.histogramUpperBounds[i];
            elt.label = formatter.format(this.analysis.histogramLowerBounds[i]) + "-" + formatter.format(this.analysis.histogramUpperBounds[i]);
            ret.add(elt);
        }
        return ret;
    }
}

