/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ColumnMapper {
    private final ExpressionBuilder.ExpressionBuilderFactory ef;
    private Map<String, List<ValueComputer>> map = new LinkedHashMap<String, List<ValueComputer>>();
    private SQLDialect dialect;

    public ColumnMapper(SQLDialect dialect) {
        this.dialect = dialect;
        this.ef = new ExpressionBuilder.ExpressionBuilderFactory();
    }

    public synchronized String dumpAsString() {
        Object out = "";
        for (Map.Entry<String, List<ValueComputer>> entry : this.map.entrySet()) {
            out = (String)out + "* Column \"" + entry.getKey() + "\"\n";
            for (ValueComputer vc : entry.getValue()) {
                out = (String)out + "   > " + vc.getClass().getSimpleName() + "\n";
            }
            TypedExpr expr = this.get(entry.getKey());
            out = (String)out + "  SQL: " + expr.expr + "\n";
            out = (String)out + "  Type: " + expr.type.type.name() + " (" + (expr.type.canBeNull ? "nullable" : "non-null") + ")\n";
            out = (String)out + "\n";
        }
        return out;
    }

    private String lowerIfInsensitive(String colName) {
        if (this.dialect.hasCaseInsensitiveColumns() && colName != null) {
            return colName.toLowerCase();
        }
        return colName;
    }

    public synchronized List<Pair<String, ExprType>> dump() {
        ArrayList<Pair<String, ExprType>> out = new ArrayList<Pair<String, ExprType>>();
        for (Map.Entry<String, List<ValueComputer>> entry : this.map.entrySet()) {
            TypedExpr expr = this.get(entry.getKey());
            Pair col = new Pair((Object)entry.getKey(), (Object)expr.type);
            out.add((Pair<String, ExprType>)col);
        }
        return out;
    }

    public synchronized TypedExpr getAs(String columnName, ExprType type) {
        columnName = this.lowerIfInsensitive(columnName);
        return this.getAs(columnName, type, null);
    }

    public synchronized TypedExpr getAs(String columnName, ExprType type, String sqlExpr) {
        List<ValueComputer> computers;
        columnName = this.lowerIfInsensitive(columnName);
        if (sqlExpr == null) {
            sqlExpr = this.dialect.quoteIdentifier(columnName);
        }
        if ((computers = this.map.get(columnName)) == null) {
            throw new RuntimeException("Column \"" + columnName + "\" doesn't exist !");
        }
        TypedExpr current = new TypedExpr(sqlExpr, ExprType.UNKNOWN);
        for (ValueComputer comp : computers) {
            current = comp.compute(current);
        }
        ValueCaster caster = new ValueCaster(type);
        current = caster.compute(current);
        return current;
    }

    public synchronized TypedExpr get(String columnName) {
        columnName = this.lowerIfInsensitive(columnName);
        TypedExpr current = new TypedExpr(this.dialect.quoteIdentifier(columnName), ExprType.UNKNOWN);
        List<ValueComputer> computers = this.map.get(columnName);
        if (computers == null) {
            throw new RuntimeException("Column \"" + columnName + "\" doesn't exist !");
        }
        for (ValueComputer comp : computers) {
            current = comp.compute(current);
        }
        return current;
    }

    public synchronized TypedExpr get(String columnName, String sqlExpr) {
        columnName = this.lowerIfInsensitive(columnName);
        TypedExpr current = new TypedExpr(sqlExpr, ExprType.UNKNOWN);
        List<ValueComputer> computers = this.map.get(columnName);
        if (computers == null) {
            throw new RuntimeException("Column \"" + columnName + "\" doesn't exist !");
        }
        for (ValueComputer comp : computers) {
            current = comp.compute(current);
        }
        return current;
    }

    public synchronized TypedExpr getAs(TypedExpr tv, ExprType toType) {
        ValueCaster vc = new ValueCaster(toType);
        return vc.compute(tv);
    }

    public synchronized boolean hasComputer(String columnName, Class<? extends ValueComputer> clazz) {
        columnName = this.lowerIfInsensitive(columnName);
        TypedExpr current = new TypedExpr(this.dialect.quoteIdentifier(columnName), ExprType.UNKNOWN);
        List<ValueComputer> computers = this.map.get(columnName);
        if (computers == null) {
            throw new RuntimeException("Column \"" + columnName + "\" doesn't exist !");
        }
        for (ValueComputer comp : computers) {
            if (!clazz.isAssignableFrom(comp.getClass())) continue;
            return true;
        }
        return false;
    }

    public synchronized void addColumn(String srcColumnName, ExprType type) {
        srcColumnName = this.lowerIfInsensitive(srcColumnName);
        ArrayList<TypedIdentity> computers = new ArrayList<TypedIdentity>();
        computers.add(new TypedIdentity(type));
        this.map.put(srcColumnName, computers);
    }

    public synchronized void map(String srcColumnName, ExprType type) {
        List<ValueComputer> computers = this.map.get(srcColumnName = this.lowerIfInsensitive(srcColumnName));
        if (computers == null) {
            throw new RuntimeException("Column \"" + srcColumnName + "\" doesn't exist !");
        }
        computers.add(new ValueCaster(type));
    }

    public synchronized void map(String srcColumnName, ValueComputer vc) {
        List<ValueComputer> computers = this.map.get(srcColumnName = this.lowerIfInsensitive(srcColumnName));
        if (computers == null) {
            throw new RuntimeException("Column \"" + srcColumnName + "\" doesn't exist !");
        }
        computers.add(vc);
    }

    public static interface ValueComputer {
        public TypedExpr compute(TypedExpr var1);
    }

    public static class TypedExpr {
        public String expr;
        public ExprType type;

        public TypedExpr(String expr, ExprType type) {
            this.expr = expr;
            this.type = type;
        }
    }

    public static enum ExprType {
        STRING(BaseType.STRING, true),
        DATE(BaseType.DATE, true),
        NUMBER(BaseType.NUMBER, true),
        UNKNOWN(BaseType.UNKNOWN, true),
        NON_NULL_STRING(BaseType.STRING, false),
        NON_NULL_DATE(BaseType.DATE, false),
        NON_NULL_NUMBER(BaseType.NUMBER, false),
        NON_NULL_UNKNOWN(BaseType.UNKNOWN, false);

        public final BaseType type;
        public final boolean canBeNull;

        private ExprType(BaseType type, boolean canBeNull) {
            this.type = type;
            this.canBeNull = canBeNull;
        }
    }

    public static enum BaseType {
        STRING,
        DATE,
        NUMBER,
        UNKNOWN;

    }

    private class ValueCaster
    implements ValueComputer {
        private ExprType castTo;

        public ValueCaster(ExprType castTo) {
            this.castTo = castTo;
        }

        @Override
        public TypedExpr compute(TypedExpr value) {
            Object expr = value.expr;
            ExprType outputType = this.castTo;
            if (value.type.type != this.castTo.type) {
                switch (this.castTo.type) {
                    case NUMBER: {
                        expr = ColumnMapper.this.dialect.convertStringToNumber((String)expr);
                        break;
                    }
                    case STRING: {
                        expr = ColumnMapper.this.ef.expr((String)expr).castToString(512).toSQL(ColumnMapper.this.dialect);
                        break;
                    }
                    case DATE: {
                        expr = "CAST((" + (String)expr + ") AS TIMESTAMP)";
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unreachable");
                    }
                }
            }
            if (value.type.canBeNull && !this.castTo.canBeNull) {
                switch (this.castTo.type) {
                    case STRING: {
                        if (ColumnMapper.this.dialect instanceof OracleSQLDialect) {
                            expr = "NVL(" + (String)expr + "," + ColumnMapper.this.dialect.quoteString("___dku_no_value___") + ")";
                            break;
                        }
                        expr = "COALESCE(" + (String)expr + "," + ColumnMapper.this.dialect.quoteString("___dku_no_value___") + ")";
                        break;
                    }
                    case DATE: {
                        outputType = ExprType.DATE;
                        break;
                    }
                    case NUMBER: {
                        outputType = ExprType.NUMBER;
                        break;
                    }
                    case UNKNOWN: {
                        outputType = ExprType.UNKNOWN;
                    }
                }
            }
            return new TypedExpr((String)expr, outputType);
        }
    }

    private class TypedIdentity
    implements ValueComputer {
        private ExprType type;

        public TypedIdentity(ExprType type) {
            this.type = type;
        }

        @Override
        public TypedExpr compute(TypedExpr tv) {
            return new TypedExpr(tv.expr, this.type);
        }
    }
}

