/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.PluginEntryPoint;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.server.SpringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HadoopJavaPluginsHelper {
    private static Logger logger = Logger.getLogger((String)"dku.plugins");

    public static PluginsWithJavaState buildState() {
        IPluginsRegistryService ps2 = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        PluginsWithJavaState pwjs = new PluginsWithJavaState();
        for (InstalledPluginDesc ipd : ps2.getLoadedPlugins()) {
            if (ipd.desc.entryPoint == null) continue;
            pwjs.entryPoints.add(ipd.desc.entryPoint);
        }
        return pwjs;
    }

    public static void load(PluginsWithJavaState pjs) {
        for (String clazz : pjs.entryPoints) {
            try {
                PluginEntryPoint pep = (PluginEntryPoint)Class.forName(clazz).newInstance();
                pep.load();
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to initialize plugin entry point " + clazz), (Throwable)e);
            }
        }
    }

    public static class PluginsWithJavaState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public List<String> entryPoints = new ArrayList<String>();
    }
}

