/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;

@PartOfPublicAPI
public class ProjectStandardsCheckRunResult {
    public ProjectStandardsCheckRunStatus status;
    @Nullable
    public Integer severity;
    public String message;
    @Nullable
    JsonObject details;

    private ProjectStandardsCheckRunResult() {
    }

    public ProjectStandardsCheckRunResult(ProjectStandardsCheckRunStatus status, @Nullable Integer severity, String message, @Nullable JsonObject details) {
        this.status = status;
        this.severity = severity;
        this.message = message;
        this.details = details;
    }

    public static ProjectStandardsCheckRunResult createErrorResult(String message, @Nullable JsonObject details) {
        String escaped = StringEscapeUtils.escapeHtml((String)message);
        return new ProjectStandardsCheckRunResult(ProjectStandardsCheckRunStatus.RUN_ERROR, null, escaped, details);
    }

    public boolean hasInvalidSeverity() {
        if (this.status != ProjectStandardsCheckRunStatus.RUN_SUCCESS) {
            return false;
        }
        return this.severity == null || this.severity < 0 || this.severity > 5;
    }

    public String toString() {
        return "ProjectStandardsCheckRunResult{status=" + String.valueOf((Object)this.status) + ", severity=" + this.severity + ", message='" + this.message + "', details=" + String.valueOf(this.details) + "}";
    }

    public static enum ProjectStandardsCheckRunStatus {
        RUN_SUCCESS,
        RUN_ERROR,
        NOT_APPLICABLE;

    }
}

