/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryLikeRecipeRunner;
import com.dataiku.dip.utils.DKULogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ImpalaRecipeExecutionUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dip.impala.exec");

    public static void executeStatementsChainInImpala(SQLConnectionProvider.SQLConnectionWrapper conn, Dataset outputDataset, String transformedQuery, List<String> optionalPreSqlQuery, List<String> preSqlQuery, List<String> postSqlQuery, AbstractSQLQueryLikeRecipeRunner runner) throws SQLException {
        Statement stmt;
        Object stmt2;
        conn.setAutoCommit(false);
        if (outputDataset.getFormatType().equals(ParquetFormatMeta.META.getType())) {
            stmt2 = conn.createStatement();
            try {
                String compressionName = "NONE";
                if (outputDataset.getFormatParamsAs(ParquetFormatConfig.class).parquetCompressionMethod == ParquetFormatConfig.CompressionMethod.GZIP) {
                    compressionName = "GZIP";
                } else if (outputDataset.getFormatParamsAs(ParquetFormatConfig.class).parquetCompressionMethod == ParquetFormatConfig.CompressionMethod.SNAPPY) {
                    compressionName = "SNAPPY";
                } else if (outputDataset.getFormatParamsAs(ParquetFormatConfig.class).parquetCompressionMethod == ParquetFormatConfig.CompressionMethod.ZSTD) {
                    compressionName = "ZSTD";
                }
                runner.executeCancellableStatement(conn, (Statement)stmt2, "set COMPRESSION_CODEC=" + compressionName);
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        if (optionalPreSqlQuery != null) {
            for (String query : optionalPreSqlQuery) {
                try {
                    stmt = conn.createStatement();
                    try {
                        runner.executeCancellableStatement(conn, stmt, query);
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Optional pre-query statement failed", (Throwable)e);
                }
            }
        }
        if (preSqlQuery != null) {
            for (String query : preSqlQuery) {
                stmt = conn.createStatement();
                try {
                    runner.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
        stmt2 = conn.createStatement();
        try {
            runner.executeCancellableStatement(conn, (Statement)stmt2, transformedQuery);
        }
        finally {
            if (stmt2 != null) {
                stmt2.close();
            }
        }
        if (postSqlQuery != null) {
            for (String query : postSqlQuery) {
                stmt = conn.createStatement();
                try {
                    runner.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
    }
}

