/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.scala;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.util.List;

public class SparkScalaRecipeRunner
extends AbstractSparkBasedRecipeRunner
implements RecipeRunnerWithPayload {
    private SparkScalaRecipeMeta.SparkScalaRecipeParams params;
    private String code;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sparkscala");

    public SparkScalaRecipeRunner(JobActivity activity) {
        super(activity);
        this.params = RecipeRegistry.getParamsAs(activity, SparkScalaRecipeMeta.SparkScalaRecipeParams.class);
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    @Override
    public void run() throws Exception {
        this.runSpark("Scala", this.params.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File tmpScriptData = new File(runDir, "recipe.scala");
                DKUFileUtils.writeFileUTF8((File)tmpScriptData, (String)SparkScalaRecipeRunner.this.code);
                Boolean useGlobalMetastore = SparkScalaRecipeRunner.this.params.codeMode == CodeMode.FUNCTION && SparkScalaRecipeRunner.this.params.useGlobalMetastore;
                String metastoreDatabase = null;
                if (useGlobalMetastore.booleanValue() && (metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(SparkScalaRecipeRunner.this.activity, SparkScalaRecipeRunner.this.datasetsDAO)) == null) {
                    logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default. You can override from the code with sqlContext.sql(\"USE my_database\")");
                }
                T job = helper.makeClassJob("Spark-Scala Recipe", true, effectiveConf, "com.dataiku.dip.spark.recipe.SparkScalaRecipeEntryPoint", tmpScriptData.getAbsolutePath(), SparkScalaRecipeRunner.this.params.codeMode.toString(), useGlobalMetastore.toString(), metastoreDatabase == null ? "" : metastoreDatabase);
                ((SparkJob)job).secretDriverFiles.add(tmpScriptData.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return SparkScalaRecipeRunner.this.params.sparkConfig;
            }
        }, null);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }
}

