/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.HadoopDelegationTokensGenerator;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.MapRTicketGenerator;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkBasedActivityHelper
implements AutoCloseable {
    private static Set<String> SPARK_CONF_KEY_TO_PICK = Sets.newHashSet((Object[])new String[]{"spark.yarn.access.hadoopFileSystems", "spark.yarn.access.namenodes"});
    private final String projectKey;
    private final AuthCtx authCtx;
    private SparkJobExecEnv baseDef = new SparkJobExecEnv();
    private final UserImpersonationTarget initialImpersonationTarget;
    @Autowired
    private IImpersonationResolverService impersonationService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private File processRunDir;
    private File hadoopDelegationTokensFile;
    private Map<String, String> extraExtraEnv = new HashMap<String, String>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark.activity");

    public SparkBasedActivityHelper(String projectKey, AuthCtx authCtx, File processRunDir, UserImpersonationTarget impersonationTarget) {
        this.initialImpersonationTarget = impersonationTarget;
        SpringUtils.getInstance().autowire((Object)this);
        this.projectKey = projectKey;
        this.authCtx = authCtx;
        this.processRunDir = processRunDir;
    }

    public void addExtraExtraEnv(String key, String value) {
        this.extraExtraEnv.put(key, value);
    }

    public File getProcessRunDir() {
        return this.processRunDir;
    }

    public String getDelegationTokenFileLocation() {
        if (this.impersonationService.isEnabled() && this.hadoopDelegationTokensFile != null) {
            return this.hadoopDelegationTokensFile.getAbsolutePath();
        }
        return null;
    }

    public Map<String, String> getProcessExtraEnv() throws DKUSecurityException {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.impersonationService.isEnabled()) {
            if (this.hadoopDelegationTokensFile != null) {
                if (MapRTicketGenerator.isMapR()) {
                    ret.put("MAPR_TICKETFILE_LOCATION", this.hadoopDelegationTokensFile.getAbsolutePath());
                } else {
                    ret.put("HADOOP_TOKEN_FILE_LOCATION", this.hadoopDelegationTokensFile.getAbsolutePath());
                    if (ApplicationConfigurator.getParams().getBoolParam("dku.hadoop.impersonation.forceUserName", false)) {
                        ret.put("HADOOP_USER_NAME", this.getImpersonationTarget().hadoopUser);
                    }
                }
            }
        } else if (HadoopLoader.isKerberosLoginEnabled()) {
            HadoopLoader.addTicketCacheEnvVar(ret);
        }
        ret.putAll(this.extraExtraEnv);
        return ret;
    }

    private UserImpersonationTarget getImpersonationTarget() throws DKUSecurityException {
        if (this.initialImpersonationTarget != null) {
            return this.initialImpersonationTarget;
        }
        return this.impersonationService.getTargetUser(this.projectKey, this.authCtx);
    }

    public void addProcessExtraEnv(ProcessBuilder pb) throws DKUSecurityException {
        for (Map.Entry<String, String> e : this.getProcessExtraEnv().entrySet()) {
            pb.environment().put(e.getKey(), e.getValue());
        }
    }

    public SparkJobExecEnv configure(String activityProjectKey, JobActivity activity, List<SimpleKeyValue> sparkConf) throws IOException, DKUSecurityException, InterruptedException {
        logger.infoV("configure activity helper activityProjectKey=%s activity=%s type=%s", new Object[]{activityProjectKey, JSON.pretty((Object)activity.getSerialized()), activity.getClass()});
        HashSet<String> relevantProjects = new HashSet<String>();
        relevantProjects.add(activityProjectKey);
        if (activity.getSubgraph() != null) {
            for (FlowComputable flowComputable : activity.getSubgraph().getSources()) {
                relevantProjects.add(AnyLoc.resolveFull(flowComputable.getFullId()).getProjectKey());
            }
        } else {
            logger.info((Object)"No subgraph for activity!");
        }
        logger.infoV("Resulting relevant projects: %s", new Object[]{JSON.json(relevantProjects)});
        return this.configure(relevantProjects, sparkConf);
    }

    public SparkJobExecEnv configure(Set<String> relevantProjects, List<SimpleKeyValue> sparkConf) throws IOException, DKUSecurityException, InterruptedException {
        return this.configure(relevantProjects, sparkConf, null);
    }

    public void configure(String activityProjectKey, ContinuousActivity activity, List<SimpleKeyValue> sparkConf) throws IOException, DKUSecurityException, InterruptedException {
        HashSet<String> relevantProjects = new HashSet<String>();
        relevantProjects.add(activityProjectKey);
        this.processRunDir = FlowJobUtils.getTmpFolder("sparkbased-recipe", "out").getCanonicalFile();
        Logger.getLogger((String)"dku").info((Object)("Setting process run dir " + String.valueOf(this.processRunDir)));
        this.configure(relevantProjects, sparkConf);
    }

    public SparkJobExecEnv configure(Set<String> relevantProjects, List<SimpleKeyValue> sparkConf, ClusterSettings clusterSettings) throws IOException, DKUSecurityException, InterruptedException {
        if (clusterSettings == null) {
            clusterSettings = new ClusterSelector().selectForProject(this.authCtx, this.projectKey);
        }
        for (SimpleKeyValue var : clusterSettings.getSparkSettings().environmentVariables) {
            this.extraExtraEnv.put(var.key, var.value);
        }
        if (this.impersonationService.isEnabled()) {
            UserImpersonationTarget impersonated = this.getImpersonationTarget();
            FilesystemACLHandler aclHandler = new FilesystemACLHandler();
            aclHandler.setExclusiveAndStudioFullAccessOnDirectory(this.processRunDir, impersonated.unixUser);
            if (HadoopLoader.hadoopEnabled() && !HadoopDelegationTokensGenerator.isDisabled() && this.impersonationService.usesHadoopDelegationTokens()) {
                this.hadoopDelegationTokensFile = new File(this.processRunDir, "dt-" + DKUDateUtils.isoFormatFileFriendlyLocalNow() + ".creds");
                HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
                List<SimpleKeyValue> extraConf = hadoopSettings.extraConf.getAsSimpleKeyValueList();
                extraConf.addAll(clusterSettings.getHiveSettings().executionConfigsGenericOverrides.getAsSimpleKeyValueList());
                for (SimpleKeyValue kv : sparkConf) {
                    if (kv.key.startsWith("spark.hadoop.")) {
                        extraConf.add(new SimpleKeyValue(kv.key.substring("spark.hadoop.".length()), kv.value));
                    }
                    if (!SPARK_CONF_KEY_TO_PICK.contains(kv.key)) continue;
                    extraConf.add(kv);
                }
                if (MapRTicketGenerator.isMapR()) {
                    MapRTicketGenerator.generateTicketForUser(impersonated.hadoopUser, this.hadoopDelegationTokensFile.getAbsolutePath());
                } else {
                    HadoopDelegationTokensGenerator.generateSparkTokenFile(impersonated.hadoopUser, "file://" + this.hadoopDelegationTokensFile.getAbsolutePath(), extraConf);
                }
                aclHandler.setExclusiveAndStudioFullAccessOnDirectory(this.processRunDir, impersonated.unixUser);
            }
            this.baseDef.fillInBackendOrJEK(relevantProjects, this.authCtx, impersonated, clusterSettings.getHadoopSettings(), true);
        } else {
            this.baseDef.fillInBackendOrJEK(relevantProjects, this.authCtx, null, clusterSettings.getHadoopSettings(), true);
        }
        return this.baseDef;
    }

    public void setCloudCredentialsConfKeys(SparkExecutionConfig sec) throws IOException, DKUSecurityException {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        if (sec.cloudCredentialsSettings.enabled) {
            Object decryptedConn;
            logger.info((Object)"Enabling cloud credentials");
            LinkedHashMap<String, EC2Connection> candidateEC2Connections = new LinkedHashMap<String, EC2Connection>();
            LinkedHashMap<String, AzureConnection> candidateAzureConnections = new LinkedHashMap<String, AzureConnection>();
            LinkedHashMap<String, GCSConnection> candidateGCPConnections = new LinkedHashMap<String, GCSConnection>();
            for (Map.Entry<String, DSSConnection> e : ConnectionsDAO.get().listUnsafe().entrySet()) {
                if (!e.getValue().detailsReadableBy(this.authCtx)) continue;
                if (e.getValue() instanceof EC2Connection && ((EC2Connection)e.getValue()).params.hdfsInterface != S3DatasetHandler.HDFSInterface.NONE) {
                    candidateEC2Connections.put((String)e.getKey(), (EC2Connection)e.getValue());
                    continue;
                }
                if (e.getValue() instanceof AzureConnection && ((AzureConnection)e.getValue()).params.hdfsInterface != AzureBlobDatasetHandler.HDFSInterface.NONE) {
                    candidateAzureConnections.put((String)e.getKey(), (AzureConnection)e.getValue());
                    continue;
                }
                if (!(e.getValue() instanceof GCSConnection) || ((GCSConnection)e.getValue()).params.hdfsInterface == GCSConnection.HDFSInterface.NONE) continue;
                candidateGCPConnections.put((String)e.getKey(), (GCSConnection)e.getValue());
            }
            EC2Connection providingEC2Connection = null;
            block0 : switch (sec.cloudCredentialsSettings.aws.mode) {
                case NONE: {
                    break;
                }
                case ANY_MATCH: {
                    logger.info((Object)("any match, have " + candidateEC2Connections.size() + " connections"));
                    if (candidateEC2Connections.size() <= 0) break;
                    providingEC2Connection = (EC2Connection)candidateEC2Connections.values().iterator().next();
                    break;
                }
                case FIRST_MATCH: {
                    for (String connectionName : sec.cloudCredentialsSettings.aws.connections) {
                        if (!candidateEC2Connections.containsKey(connectionName)) continue;
                        providingEC2Connection = (EC2Connection)candidateEC2Connections.get(connectionName);
                        break block0;
                    }
                    break;
                }
            }
            if (sec.cloudCredentialsSettings.aws.mode != SparkExecutionConfig.SparkCloudCredentialsSettings.CloudCredentialsProvidingMode.NONE && providingEC2Connection == null) {
                logger.warn((Object)"Requested credentials for EC2, but no connection was suitable, no credentials will be available");
            }
            if (providingEC2Connection != null) {
                decryptedConn = (EC2Connection)JSON.deepCopy(providingEC2Connection);
                this.baseDef.awsCredential = ((DSSConnection)decryptedConn).getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
                this.baseDef.additionalSparkConf.addAll(((EC2Connection)decryptedConn).getSparkConfigForS3Access(this.authCtx));
                if (sec.cloudCredentialsSettings.aws.provideGlueClientCredential) {
                    this.baseDef.additionalSparkConf.add(new AbstractSQLConnection.CustomDatabaseProperty("spark.hadoop.aws.catalog.credentials.provider.factory.class", "com.dataiku.dip.spark.aws.RemoteRunEnvGlueCredentialsProviderFactory", false));
                }
            } else {
                logger.warn((Object)"No providing ec2 connection");
            }
            AzureConnection providingAzureConnection = null;
            block5 : switch (sec.cloudCredentialsSettings.azure.mode) {
                case NONE: {
                    break;
                }
                case ANY_MATCH: {
                    logger.info((Object)("any match, have " + candidateAzureConnections.size() + " connections"));
                    if (candidateAzureConnections.size() <= 0) break;
                    providingAzureConnection = (AzureConnection)candidateAzureConnections.values().iterator().next();
                    break;
                }
                case FIRST_MATCH: {
                    for (String connectionName : sec.cloudCredentialsSettings.azure.connections) {
                        if (!candidateAzureConnections.containsKey(connectionName)) continue;
                        providingAzureConnection = (AzureConnection)candidateAzureConnections.get(connectionName);
                        break block5;
                    }
                    break;
                }
            }
            if (sec.cloudCredentialsSettings.azure.mode != SparkExecutionConfig.SparkCloudCredentialsSettings.CloudCredentialsProvidingMode.NONE && providingAzureConnection == null) {
                logger.warn((Object)"Requested credentials Azure EC2, but no connection was suitable, no credentials will be available");
            }
            if (providingAzureConnection != null) {
                decryptedConn = (AzureConnection)JSON.deepCopy(providingAzureConnection);
                this.baseDef.additionalSparkConf.addAll(((AzureConnection)decryptedConn).getSparkConfigForAzureAccess(this.authCtx));
            } else {
                logger.warn((Object)"No providing Azure connection");
            }
            GCSConnection providingGCSConnection = null;
            block10 : switch (sec.cloudCredentialsSettings.gcp.mode) {
                case NONE: {
                    break;
                }
                case ANY_MATCH: {
                    logger.info((Object)("any match, have " + candidateGCPConnections.size() + " connections"));
                    if (candidateGCPConnections.size() <= 0) break;
                    providingGCSConnection = (GCSConnection)candidateGCPConnections.values().iterator().next();
                    break;
                }
                case FIRST_MATCH: {
                    for (String connectionName : sec.cloudCredentialsSettings.gcp.connections) {
                        if (!candidateGCPConnections.containsKey(connectionName)) continue;
                        providingGCSConnection = (GCSConnection)candidateGCPConnections.get(connectionName);
                        break block10;
                    }
                    break;
                }
            }
            if (sec.cloudCredentialsSettings.gcp.mode != SparkExecutionConfig.SparkCloudCredentialsSettings.CloudCredentialsProvidingMode.NONE && providingGCSConnection == null) {
                logger.warn((Object)"Requested credentials for GCS, but no connection was suitable, no credentials will be available");
            }
            if (providingGCSConnection != null) {
                decryptedConn = (GCSConnection)JSON.deepCopy(providingGCSConnection);
                this.baseDef.additionalSparkConf.addAll(((GCSConnection)decryptedConn).getSparkConfigForGCSAccess(this.authCtx));
            } else {
                logger.warn((Object)"No providing GCS connection");
            }
        } else {
            logger.info((Object)"cloud credentials not enabled");
        }
    }

    @Override
    public void close() {
    }

    public SparkJobExecEnv getJobExecEnv() {
        return this.baseDef;
    }
}

