/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.FlowStreamingEndpointRef;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SparkRecipeUtils {
    private static final Logger logger = Logger.getLogger((String)"dku.spark.utils");

    public static String getHiveMetastoreDatabase(JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        String db;
        for (FlowDataset out : activity.getSubgraph().getTargetsDatasets()) {
            db = SparkRecipeUtils.getMetastoreDatabase(out, datasetsDAO);
            if (db == null) continue;
            return db;
        }
        for (FlowDataset in : activity.getSubgraph().getSourceDatasets()) {
            db = SparkRecipeUtils.getMetastoreDatabase(in, datasetsDAO);
            if (db == null) continue;
            return db;
        }
        return null;
    }

    private static String getMetastoreDatabase(FlowDataset dataset, DatasetsDAO datasetsDAO) throws IOException {
        Dataset ds = Dataset.fromSerializedUnsafe((SerializedDataset)datasetsDAO.getMandatoryUnsafe(DatasetLocUtils.resolveFull(dataset.getFullName())));
        if (DatasetInspector.isHDFSDatasetOrHiveTableDataset(ds) && DatasetInspector.syncsHiveTable(ds)) {
            return HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds).getSchemaNullIfBlank();
        }
        return null;
    }

    public static FlowDatasetRef getInputFlowDatasetRef(FlowDataset in, InputDatasetsReadParams readParams, boolean useGlobalMetastore, FlowRecipe recipe, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        Dataset ds = in.getMandatory(datasetsDAO);
        ArrayList<Partition> sourcePartitions = ds.getPartitioningSchema().isPartitioned() && activity != null ? activity.getSubgraph().getSourcePartitions(in) : new ArrayList<Partition>();
        return SparkRecipeUtils.getInputFlowDatasetRef(ds, readParams, useGlobalMetastore, recipe, sourcePartitions);
    }

    public static FlowDatasetRef getInputFlowDatasetRef(Dataset ds, InputDatasetsReadParams readParams, boolean useGlobalMetastore, FlowRecipe recipe, List<Partition> sourcePartitions) throws IOException {
        return SparkRecipeUtils.getInputFlowDatasetRef(ds, readParams, useGlobalMetastore, recipe.getProjectKey(), sourcePartitions);
    }

    public static FlowDatasetRef getInputFlowDatasetRef(Dataset ds, InputDatasetsReadParams readParams, boolean useGlobalMetastore, String projectKey, List<Partition> sourcePartitions) throws IOException {
        boolean needsRepartition;
        FlowDatasetRef fdr = new FlowDatasetRef();
        String datasetFullName = ds.getFullName();
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(datasetFullName);
        fdr.ref = loc.getSmartName(projectKey);
        fdr.fullName = datasetFullName;
        if (DatasetInspector.hasAssociatedMetastoreTable(ds) || DatasetInspector.isHiveTable(ds)) {
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
            fdr.tableName = tableRef.getTable();
            fdr.databaseName = tableRef.getSchemaNullIfBlank();
            fdr.registerAsTempTable = !useGlobalMetastore;
        } else {
            fdr.tableName = loc.getId();
            fdr.registerAsTempTable = true;
        }
        boolean bl = needsRepartition = !DatasetInspector.isHDFSDatasetOrHiveTableDataset(ds);
        if (readParams.map.get(fdr.ref) == null) {
            InputDatasetsReadParams.InputDatasetReadParams id = new InputDatasetsReadParams.InputDatasetReadParams();
            id.repartition = needsRepartition ? 10 : 1;
            readParams.map.put(fdr.ref, id);
        }
        if (readParams.map.get((Object)fdr.ref).repartition > 1 && !needsRepartition) {
            logger.warn((Object)("Forcing repartitioning of dataset not needing it (in " + readParams.map.get((Object)fdr.ref).repartition + "), maybe not a good idea"));
        }
        if (sourcePartitions != null && ds.getPartitioningSchema().isPartitioned()) {
            fdr.partitions = new ArrayList<String>();
            for (Partition p : sourcePartitions) {
                fdr.partitions.add(p.id());
            }
        }
        return fdr;
    }

    public static FlowDatasetRef getOutputFlowDatasetRef(FlowDataset out, String projectKey, JobActivity activity, DatasetsDAO datasetsDAO) throws IOException {
        Dataset ds = out.getMandatoryUnsafe(datasetsDAO);
        Partition partition = ds.getPartitioningSchema().isPartitioned() ? activity.getSubgraph().getTargetPartition(out) : Partition.newNP();
        return SparkRecipeUtils.getOutputFlowDatasetRef(ds, projectKey, partition);
    }

    public static FlowDatasetRef getOutputFlowDatasetRef(Dataset ds, String projectKey, Partition partition) {
        String datasetFullName = ds.getFullName();
        return SparkRecipeUtils.getOutputFlowDatasetRef(datasetFullName, projectKey, partition, ds.getPartitioningSchema());
    }

    public static FlowDatasetRef getOutputFlowDatasetRef(String datasetFullName, String projectKey, Partition partition, PartitioningScheme partitioningScheme) {
        FlowDatasetRef fdr = new FlowDatasetRef();
        fdr.ref = DatasetLocUtils.resolveFull(datasetFullName).getSmartName(projectKey);
        fdr.fullName = datasetFullName;
        fdr.tableName = DatasetLocUtils.resolveFull(datasetFullName).getName();
        if (partition != null && partitioningScheme.isPartitioned()) {
            fdr.partitions = new ArrayList<String>();
            fdr.partitions.add(partition.id());
        }
        return fdr;
    }

    public static FlowStreamingEndpointRef getInputFlowStreamingEndpointRef(StreamingEndpoint se, String projectKey) throws IOException {
        FlowStreamingEndpointRef fdr = new FlowStreamingEndpointRef();
        String seFullName = se.getFullId();
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(seFullName);
        fdr.ref = loc.getSmartName(projectKey);
        fdr.fullName = seFullName;
        return fdr;
    }

    public static FlowStreamingEndpointRef getOutputFlowStreamingEndpointRef(StreamingEndpoint se, String projectKey) throws IOException {
        FlowStreamingEndpointRef fdr = new FlowStreamingEndpointRef();
        String seFullName = se.getFullId();
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(seFullName);
        fdr.ref = loc.getSmartName(projectKey);
        fdr.fullName = seFullName;
        return fdr;
    }

    public static void clearActivityOutputsIfNeeded(JobActivity activity, DatasetsDAO datasetsDAO, FlowRecipe recipe, AuthCtx authCtx) throws Exception {
        for (FlowDataset out : activity.getSubgraph().getTargetsDatasets()) {
            Dataset outputDataset = out.getMandatory(datasetsDAO);
            SerializedRecipe.RecipeOutput recipeOutput = recipe.getModel().getOutputAnyRole(outputDataset.getName());
            Output.WriteMode writeMode = recipeOutput.getWriteMode();
            DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(authCtx, outputDataset);
            try {
                if (writeMode != Output.WriteMode.OVERWRITE || outputDatasetHandler.outputHandlesClear() || !outputDatasetHandler.getMeta().isFSLike()) continue;
                outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{activity.getSubgraph().getTargetPartition(out)}));
            }
            finally {
                if (outputDatasetHandler == null) continue;
                outputDatasetHandler.close();
            }
        }
    }
}

