/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.common.VirtualInputBasedRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.InputDescBase;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class VirtualInputsSingleOutputRecipeCreatorBase
extends SingleOutputDatasetRecipeCreator {
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.common.creator");

    public VirtualInputsSingleOutputRecipeCreatorBase(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    public <P extends VirtualInputBasedRecipePayloadParams<? extends InputDescBase>> RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData, Class<P> payloadClazz) throws Exception {
        assert (StringUtils.isNotBlank((String)projectKey));
        assert (this.meta.getType().equals(source.recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)source.recipe.name), (Object)"Recipe has no name");
        List<SerializedRecipe.RecipeOutput> outputs = source.recipe.getOutputsForRole("main");
        Preconditions.checkArgument((outputs.size() == 1 ? 1 : 0) != 0, (Object)(this.meta.getType() + " recipes require one output"));
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            ArrayList<String> refs = new ArrayList<String>();
            ArrayList<Integer> mapping = new ArrayList<Integer>();
            SingleOutputDatasetRecipeCreator.SingleOutputRecipeCopySettings settings = (SingleOutputDatasetRecipeCreator.SingleOutputRecipeCopySettings)JSON.parse((JsonElement)copyData, SingleOutputDatasetRecipeCreator.SingleOutputRecipeCopySettings.class);
            List<SerializedRecipe.RecipeInput> replacements = ((SerializedRecipe.InputRole)settings.inputs.get((Object)"main")).items;
            for (SerializedRecipe.RecipeInput newInput : replacements) {
                AnyLoc loc = AnyLoc.resolveSmart(projectKey, newInput.ref);
                String ref = loc.getSmartName(projectKey);
                int index = refs.indexOf(ref);
                if (index < 0) {
                    mapping.add(refs.size());
                    refs.add(ref);
                    continue;
                }
                mapping.add(index);
            }
            SerializedRecipe copy = this.copyCore((String)projectKey, (SerializedRecipe)source.recipe, (String)source.payload, (JsonObject)copyData).recipe;
            VirtualInputBasedRecipePayloadParams params = (VirtualInputBasedRecipePayloadParams)JSON.parse((String)source.payload, payloadClazz);
            for (InputDescBase vi : params.getVirtualInputs()) {
                vi.index = (Integer)mapping.get(vi.index);
            }
            String payload = JSON.pretty((Object)params);
            if (settings.createOutputDataset) {
                AnyLoc outputLoc = AnyLoc.resolveSmart(projectKey, ((SerializedRecipe.OutputRole)settings.outputs.get((Object)"main")).items.get((int)0).ref);
                String outputDatasetName = outputLoc.getSmartName(projectKey);
                Dataset outputDataset = this.mdcService.prepare(this.authCtx, projectKey, outputDatasetName, settings.outputDatasetSettings);
                logger.info((Object)("Creating dataset " + JSON.pretty((Object)outputDataset.serialize())));
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(copy);
                WithMessages<SerializedDataset> dsWithMsg = this.datasetSaveService.create(projectKey, outputDataset.serialize(), dsCtx, this.authCtx);
                ret.messages.mergeFrom(dsWithMsg.messages);
                try {
                    this.setOutputSchema(copy, payload, outputDataset);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to set the output schema!", (Throwable)e);
                }
                ret.messages.mergeFrom(this.datasetSaveService.saveWithoutEvents((String)projectKey, (String)outputDataset.getName(), (SerializedDataset)outputDataset.serialize(), (AuthCtx)this.authCtx).messages);
            }
            this.recipeSaveService.create(projectKey, copy, payload);
            t.commitV("Created %s recipe %s", new Object[]{copy.type, copy.name});
            RecipeCreator.CreationResult creationResult = ret.withId(copy.name);
            return creationResult;
        }
    }
}

