/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.SignTest1Samp;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.utils.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OneSampleSignTestStat
extends AbstractTestStat {
    private static final String ONE_SAMPLE_SIGN_TEST = "SIGN_TEST_ONE_SAMPLE";
    public String column;
    public double hypothesizedMedian = 0.0;

    public OneSampleSignTestStat(String column, double hypothesizedMedian) {
        this.column = column;
        this.hypothesizedMedian = hypothesizedMedian;
    }

    public OneSampleSignTestStat() {
    }

    @Override
    public MultiComputation getComputationPlan(StatsTestRecipePayloadParams<?> payloadParams) {
        SignTest1Samp testComputation = new SignTest1Samp(this.column, this.hypothesizedMedian);
        return new MultiComputation(BoxPlotFragment.getComputationPlan(this.column), testComputation);
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        row.put(cf.column("test"), ONE_SAMPLE_SIGN_TEST);
        row.put(cf.column("variable"), this.column);
        row.put(cf.column("hypothesized_median"), this.hypothesizedMedian);
    }

    @Override
    public List<Row> extractRows(ComputationResult result, StatsTestRecipePayloadParams<?> payloadParams, ColumnFactory cf, RowFactory rf) {
        double significanceLevel = payloadParams.significanceLevel();
        List<String> warnings = result.collectWarnings();
        Collection<String> errors = result.collectErrors();
        Row row = this.rowBase(significanceLevel, warnings, errors, cf, rf);
        if (!result.isAvailable()) {
            return Collections.singletonList(row);
        }
        MultiComputation.MultiComputationResult mcr = result.asMulti();
        BoxPlotFragment boxPlot = BoxPlotFragment.build(mcr.get(0));
        row.put(cf.column("sample_statistics"), JSON.json((Object)((Object)boxPlot)));
        if (mcr.get(1).isAvailable()) {
            SignTest1Samp.SignTest1SampResult tr = mcr.get(1).as(SignTest1Samp.SignTest1SampResult.class);
            double pValue = tr.pvalue;
            String conclusion = OneSampleSignTestStat.conclusion(pValue, significanceLevel);
            row.put(cf.column("count_inferior_to_hypothesized_median"), tr.nbSmaller);
            row.put(cf.column("count_superior_to_hypothesized_median"), tr.nbLarger);
            row.put(cf.column("count_equal_to_hypothesized_median"), tr.nbEqual);
            row.put(cf.column("p_value"), pValue);
            row.put(cf.column("conclusion"), conclusion);
        }
        return Collections.singletonList(row);
    }
}

