/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.PretrainedModelsService;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRule;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class EmbedDocumentsRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    @Autowired
    private PretrainedModelsService pretrainedModelsService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.embed_documents_status");

    public EmbedDocumentsRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            boolean outputFolderIsRequired;
            EmbedDocumentsRecipeStatus status = this.fastStatusIgnorePartitions(authCtx);
            EmbedDocumentsRecipeParams params = this.recipe.getParamsAs(EmbedDocumentsRecipeParams.class);
            EmbedDocumentsRecipePayloadParams desc = (EmbedDocumentsRecipePayloadParams)JSON.parse((String)this.payload, EmbedDocumentsRecipePayloadParams.class);
            ArrayList<EmbedDocumentsRule> allRules = params.getAllRules();
            if (this.recipe.getInputsForRole("metadata_dataset").stream().findFirst().isPresent()) {
                status.metadataDataset = new RecipeStatus.StepStatus();
                if (desc.filePathMetadataColumn == null) {
                    status.metadataDataset.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Metadata dataset requires the selection of a path column");
                }
            } else {
                status.metadataDataset = null;
            }
            if (params.extractionMode == EmbedDocumentsRecipeParams.ExtractionMode.MANAGED_VISUAL_ONLY) {
                String defaultVLMid = params.getDefaultVLMSelection();
                if (!this.isVlmUsable(authCtx, defaultVLMid)) {
                    status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "Select a vision model to use Visual extraction");
                }
            } else if (params.extractionMode == EmbedDocumentsRecipeParams.ExtractionMode.MANAGED_TEXT_ONLY) {
                if (!this.isStructuredExtractionCodeEnvAvailable()) {
                    status.strategy.withWarning(RecipeCodes.WARN_RECIPE_CODE_ENV_NOT_AVAILABLE, "Missing document extraction code environment to use Text-only extraction (not available)");
                }
            } else if (params.extractionMode == EmbedDocumentsRecipeParams.ExtractionMode.CUSTOM_RULES) {
                List<EnrichedLLMStructuredRef> availableVlms = this.getAvailableVLM(authCtx);
                if (allRules.isEmpty()) {
                    status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "No custom rule defined");
                }
                if (allRules.stream().anyMatch(rule -> rule.actionToPerform == null)) {
                    status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "At least one custom rule requires to select an action to be applied");
                }
                if (allRules.stream().allMatch(rule -> rule.actionToPerform.equals((Object)EmbedDocumentsRule.ActionToPerform.DONOTEXTRACT))) {
                    status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "At least one custom rule requires to select an action to be applied");
                }
                if (allRules.stream().anyMatch(rule -> rule.actionToPerform.equals((Object)EmbedDocumentsRule.ActionToPerform.VLM) && !this.isVlmAmongUsable(rule.vlmSettings.llmId, availableVlms))) {
                    status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "At least one custom rule requires a vision model to be selected");
                }
                if (allRules.stream().anyMatch(rule -> rule.actionToPerform.equals((Object)EmbedDocumentsRule.ActionToPerform.STRUCTURED)) && !this.isStructuredExtractionCodeEnvAvailable()) {
                    status.strategy.withWarning(RecipeCodes.WARN_RECIPE_CODE_ENV_NOT_AVAILABLE, "At least one custom rule requires a document extraction code environment to use Text-only extraction (not available)");
                }
            }
            boolean bl = outputFolderIsRequired = params.extractionMode == EmbedDocumentsRecipeParams.ExtractionMode.MANAGED_VISUAL_ONLY || params.extractionMode == EmbedDocumentsRecipeParams.ExtractionMode.CUSTOM_RULES && allRules.stream().anyMatch(rule -> rule.actionToPerform == EmbedDocumentsRule.ActionToPerform.VLM && rule.storeInMultimodalColumn.equals((Object)EmbedDocumentsRule.MultimodalContentType.IMAGES));
            if (outputFolderIsRequired && this.recipe.getOutputsForRole("images").stream().findFirst().isEmpty()) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "At least one augmentation strategy requires an output folder to store generated images");
            }
            EmbedDocumentsRecipeStatus embedDocumentsRecipeStatus = status;
            return embedDocumentsRecipeStatus;
        }
    }

    private List<EnrichedLLMStructuredRef> getAvailableVLM(AuthCtx authCtx) {
        try {
            return this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)this.recipe.projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT).identifiers;
        }
        catch (IOException e) {
            logger.error((Object)("Failed to list available VLMs for recipe: " + this.recipe.projectKey), (Throwable)e);
            return new ArrayList<EnrichedLLMStructuredRef>();
        }
        catch (DKUSecurityException e) {
            logger.error((Object)("Failed to list available VLMs for recipe: " + this.recipe.projectKey), (Throwable)e);
            return new ArrayList<EnrichedLLMStructuredRef>();
        }
    }

    private boolean isVlmAmongUsable(String vlmId, List<EnrichedLLMStructuredRef> availableVlms) {
        if (Strings.isNullOrEmpty((String)vlmId) || vlmId.equals("DSS_NO_SELECTION")) {
            return false;
        }
        Optional<EnrichedLLMStructuredRef> llmRef = availableVlms.stream().filter(enrichedLLM -> vlmId.equals(enrichedLLM.id)).findFirst();
        return llmRef.isPresent();
    }

    private boolean isVlmUsable(AuthCtx authCtx, String vlmId) {
        return this.isVlmAmongUsable(vlmId, this.getAvailableVLM(authCtx));
    }

    private boolean isStructuredExtractionCodeEnvAvailable() {
        String structuredExtractionCodeEnv = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings.getTextExtractionCodeEnv();
        try {
            this.codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, structuredExtractionCodeEnv);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public EmbedDocumentsRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        EmbedDocumentsRecipeStatus status = new EmbedDocumentsRecipeStatus();
        status.strategy = new RecipeStatus.StepStatus();
        status.output = new RecipeStatus.StepStatus();
        RecipeEngineStatus engineStatus = new RecipeEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS");
        status.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
        status.selectedEngine = engineStatus;
        this.performBasicStructureChecks(status, authCtx);
        JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        try {
            this.recipesValidationService.checkTargetsAreWritable(activity);
        }
        catch (CodedRuntimeException e) {
            status.topLevelMessages.withFatalV(e.code, e.getMessage(), new Object[0]);
        }
        return status;
    }

    public static class EmbedDocumentsRecipeStatus
    extends RecipeStatus {
        RecipeStatus.StepStatus metadataDataset;
        RecipeStatus.StepStatus strategy;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.metadataDataset != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.metadataDataset);
            }
            if (this.strategy != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.strategy);
            }
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            return ret;
        }
    }
}

