/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.finetuning;

import com.dataiku.dip.analysis.ml.llm.LLMSavedModelInfo;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.llm.online.LLMClient;

public interface FineTuningRunnerInterface {
    public LLMSavedModelInfo runFineTuning() throws Exception;

    public LLMClient getLLMClient() throws Exception;

    default public void ensureConnectionAllowsFinetuning() throws Exception {
        AbstractLLMConnection connection = this.getLLMClient().getConnection();
        if (!connection.getLLMConnectionParams().allowFinetuning) {
            throw new IllegalArgumentException("Fine-tuning is disabled for connection " + connection.name + ".");
        }
    }

    default public void cancelFineTuning() throws Exception {
        throw new UnsupportedOperationException("This fine-tuning operation is not cancelable");
    }
}

