/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.recipes.streaming.ksql.KsqlSynchronizer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class KsqlRecipePreprocessor {
    public static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*select\\s+.*\\s+emit\\s+changes(\\s+limit\\s+[0-9]+)?\\s*$", 34);
    public static final Pattern INSERT_INTO_PATTERN = Pattern.compile("^\\s*insert\\s+into\\s+(([^`\\s]+)|`([^`]+)`)\\s+(.*\\s+emit\\s+changes)\\s*$", 34);
    public static final Pattern INSERT_VALUES_PATTERN = Pattern.compile("^\\s*insert\\s+into\\s+(([^`\\s]+)|`([^`]+)`)\\s+(\\(.*\\)\\s+values\\s+\\(.*\\))\\s*$", 34);
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    private final ContinuousActivity activity;
    private final AuthCtx authCtx;
    private SerializedRecipe recipe;
    private String code;
    private Map<String, StreamingEndpoint> streamingEndpoints = Maps.newHashMap();
    private Map<String, KafkaConnection> connections = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dip.flow.ksql");

    public KsqlRecipePreprocessor(AuthCtx authCtx, ContinuousActivity activity, SerializedRecipe recipe) {
        this.authCtx = authCtx;
        this.activity = activity;
        this.recipe = recipe;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void prepare_T() throws Exception {
        logger.info((Object)("Getting payload for " + this.activity.projectKey + "  " + this.activity.recipeId));
        String code = this.recipesDAO.getPayloadOrNull(this.activity.projectKey, this.activity.recipeId);
        assert (code != null);
        this.prepare_T(this.recipe, code);
    }

    public void prepare_T(SerializedRecipe recipe, String payload) throws Exception {
        KafkaConnection connection;
        KafkaStreamingEndpointParams params;
        StreamingEndpoint se;
        FlowComputable computable;
        this.recipe = recipe;
        this.code = this.variablesService.getContext(this.activity.projectKey).expandAllowUnresolved(payload);
        for (SerializedRecipe.RecipeInput input : recipe.getInputsForRole("main")) {
            computable = this.computableFromRefService.get(this.activity.projectKey, input.ref);
            if (!(computable instanceof FlowStreamingEndpoint)) {
                throw new Exception("KSQL recipe only accepts streaming endpoint inputs (" + computable.getFullId() + " is " + String.valueOf((Object)computable.getType()) + ")");
            }
            se = ((FlowStreamingEndpoint)computable).getStreamingEndpoint();
            if (!"kafka".equals(se.type)) {
                throw new Exception("KSQL recipe only accepts kafka streaming endpoint inputs (" + se.id + " is " + se.type + ")");
            }
            params = se.getParamsAs(KafkaStreamingEndpointParams.class);
            se.setParams(StreamingEndpointsRegistry.getMeta(se).getExpandedParams(recipe.projectKey, se, KafkaStreamingEndpointParams.class));
            connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, params.connection, KafkaConnection.class);
            this.streamingEndpoints.put(se.getFullId(), se);
            this.connections.put(connection.name, connection);
        }
        for (SerializedRecipe.RecipeOutput output : recipe.getOutputsForRole("main")) {
            computable = this.computableFromRefService.get(this.activity.projectKey, output.ref);
            if (!(computable instanceof FlowStreamingEndpoint)) {
                throw new Exception("KSQL recipe only accepts streaming endpoint outputs (" + computable.getFullId() + " is " + String.valueOf((Object)computable.getType()) + ")");
            }
            se = ((FlowStreamingEndpoint)computable).getStreamingEndpoint();
            if (!"kafka".equals(se.type)) {
                throw new Exception("KSQL recipe only accepts kafka streaming endpoint outputs (" + se.id + " is " + se.type + ")");
            }
            params = se.getParamsAs(KafkaStreamingEndpointParams.class);
            se.setParams(StreamingEndpointsRegistry.getMeta(se).getExpandedParams(recipe.projectKey, se, KafkaStreamingEndpointParams.class));
            connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, params.connection, KafkaConnection.class);
            this.streamingEndpoints.put(se.getFullId(), se);
            this.connections.put(connection.name, connection);
        }
    }

    public String getEffectiveCode() {
        return this.code;
    }

    public SerializedRecipe getRecipe() {
        return this.recipe;
    }

    public List<StreamingEndpoint> getInputs() {
        ArrayList ret = Lists.newArrayList();
        for (SerializedRecipe.RecipeInput input : this.recipe.getInputsForRole("main")) {
            AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.activity.projectKey, input.ref);
            StreamingEndpoint se = this.streamingEndpoints.get(loc.getFullName());
            ret.add(se);
        }
        return ret;
    }

    public List<StreamingEndpoint> getOutputs() {
        ArrayList ret = Lists.newArrayList();
        for (SerializedRecipe.RecipeOutput output : this.recipe.getOutputsForRole("main")) {
            AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.activity.projectKey, output.ref);
            StreamingEndpoint se = this.streamingEndpoints.get(loc.getFullName());
            ret.add(se);
        }
        return ret;
    }

    public KafkaConnection.KsqlConnectionParams getEffectiveKsqlConnectionParams() throws Exception {
        KafkaConnection connection;
        StreamingEndpoint se;
        AnyLoc loc;
        HashSet inputServerUrls = Sets.newHashSet();
        HashSet outputServerUrls = Sets.newHashSet();
        HashMap connectionParamsByUrl = Maps.newHashMap();
        for (SerializedRecipe.RecipeInput input : this.recipe.getInputsForRole("main")) {
            loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.activity.projectKey, input.ref);
            se = this.streamingEndpoints.get(loc.getFullName());
            connection = this.connections.get(se.getParamsAs(KafkaStreamingEndpointParams.class).connection);
            if (StringUtils.isNotBlank((String)connection.params.ksqlConnectionParams.serverUrl)) {
                inputServerUrls.add(connection.params.ksqlConnectionParams.serverUrl);
                connectionParamsByUrl.put(connection.params.ksqlConnectionParams.serverUrl, connection.getKSqlParameters());
                continue;
            }
            logger.warn((Object)("Kafka endpoint " + se.id + " has no associated KSQL server URL. Will attempt to use URL from the other inputs/outputs."));
        }
        for (SerializedRecipe.RecipeOutput output : this.recipe.getOutputsForRole("main")) {
            loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.activity.projectKey, output.ref);
            se = this.streamingEndpoints.get(loc.getFullName());
            connection = this.connections.get(se.getParamsAs(KafkaStreamingEndpointParams.class).connection);
            if (StringUtils.isNotBlank((String)connection.params.ksqlConnectionParams.serverUrl)) {
                outputServerUrls.add(connection.params.ksqlConnectionParams.serverUrl);
                connectionParamsByUrl.put(connection.params.ksqlConnectionParams.serverUrl, connection.getKSqlParameters());
                continue;
            }
            logger.warn((Object)("Kafka endpoint " + se.id + " has no associated KSQL server URL. Will attempt to use URL from the other inputs/outputs."));
        }
        if (inputServerUrls.isEmpty() && outputServerUrls.isEmpty()) {
            throw new Exception("No input nor output bears a KSQL server url");
        }
        String ksqlServerUrl = inputServerUrls.isEmpty() ? (String)outputServerUrls.iterator().next() : (String)inputServerUrls.iterator().next();
        Sets.SetView allServerUrls = Sets.union((Set)inputServerUrls, (Set)outputServerUrls);
        if (allServerUrls.size() > 1) {
            logger.warn((Object)("Selected one KSQL server among " + allServerUrls.size() + " : " + ksqlServerUrl));
        } else {
            logger.info((Object)("Using KSQL server : " + ksqlServerUrl));
        }
        return (KafkaConnection.KsqlConnectionParams)connectionParamsByUrl.get(ksqlServerUrl);
    }

    public KsqlScriptAnalysis analyse() {
        KsqlScriptAnalysis ret = new KsqlScriptAnalysis();
        Splitter splitter = this.buildSplitter();
        String[] statements = splitter.split(this.code);
        for (String statement : statements) {
            KsqlScriptStatement stmt = new KsqlScriptStatement();
            stmt.statement = statement;
            Matcher selectMatcher = SELECT_PATTERN.matcher(statement);
            Matcher insertIntoMatcher = INSERT_INTO_PATTERN.matcher(statement);
            Matcher insertValuesMatcher = INSERT_VALUES_PATTERN.matcher(statement);
            if (selectMatcher.matches()) {
                stmt.type = KsqlScriptStatementType.SELECT;
                stmt.select = statement;
            } else if (insertIntoMatcher.matches()) {
                stmt.type = KsqlScriptStatementType.INSERT_INTO;
                stmt.select = insertIntoMatcher.group(4);
                stmt.streamName = StringUtils.defaultIfBlank((String)StringUtils.defaultIfBlank((String)insertIntoMatcher.group(3), (String)"").toUpperCase(), (String)insertIntoMatcher.group(2));
            } else if (insertValuesMatcher.matches()) {
                stmt.type = KsqlScriptStatementType.INSERT_VALUES;
                stmt.select = insertIntoMatcher.group(4);
                stmt.streamName = StringUtils.defaultIfBlank((String)StringUtils.defaultIfBlank((String)insertIntoMatcher.group(3), (String)"").toUpperCase(), (String)insertIntoMatcher.group(2));
            } else {
                stmt.type = KsqlScriptStatementType.OTHER;
            }
            ret.statements.add(stmt);
        }
        for (KsqlScriptStatement statement : ret.statements) {
            ret.countByType.put(statement.type, 1 + ret.countByType.getOrDefault((Object)statement.type, 0));
        }
        return ret;
    }

    private Splitter buildSplitter() {
        ArrayList portionFinders = Lists.newArrayList();
        portionFinders.add(QuotedPortionFinders.MultiLineCommentFinder.META);
        portionFinders.add(QuotedPortionFinders.SingleLineCommentFinder.META);
        portionFinders.add(QuotedPortionFinders.BackTickedNoEscapeFinder.META);
        portionFinders.add(QuotedPortionFinders.SingleQuotedNoEscapeFinder.META);
        Splitter splitter = new Splitter(portionFinders.toArray(new QuotedPortionFinderFactory[0]));
        return splitter;
    }

    public void synchronizeInputOutputs(KsqlRESTClient client, KsqlScriptAnalysis script) throws Exception {
        StreamingEndpoint se;
        AnyLoc loc;
        KsqlSynchronizer synchronizer = new KsqlSynchronizer(client);
        for (SerializedRecipe.RecipeInput input : this.recipe.getInputsForRole("main")) {
            loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.activity.projectKey, input.ref);
            se = this.streamingEndpoints.get(loc.getFullName());
            logger.info((Object)("Synchronizing " + se.id));
            KsqlSynchronizer.CompatibilityAndReason compatibility = this.getCompatibility(synchronizer, se);
            if (compatibility.compatibility == KsqlSynchronizer.Compatibility.COMPATIBLE) {
                logger.info((Object)("A stream named " + se.id + " already exists and is compatible"));
                continue;
            }
            if (compatibility.compatibility == KsqlSynchronizer.Compatibility.NOT_SYNCHRONIZABLE) {
                throw new Exception("Cannot synchronize " + se.id + " to KSQL : " + compatibility.reason);
            }
            if (compatibility.compatibility == KsqlSynchronizer.Compatibility.DOES_NOT_EXIST) {
                logger.info((Object)("No stream named " + se.id + ", synchronize one"));
                synchronizer.createTableOrStream(se);
                continue;
            }
            logger.info((Object)("A stream named " + se.id + " exists and is not compatible, synchronize anew (" + compatibility.reason + ")"));
            synchronizer.dropTableOrStream(se, true, true);
            synchronizer.createTableOrStream(se);
        }
        for (SerializedRecipe.RecipeOutput output : this.recipe.getOutputsForRole("main")) {
            loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.activity.projectKey, output.ref);
            se = this.streamingEndpoints.get(loc.getFullName());
            KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
            logger.info((Object)("Synchronizing " + se.id));
            boolean isCSASorCTASed = params.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.TABLE;
            for (KsqlScriptStatement statement : script.statements) {
                if (statement.type != KsqlScriptStatementType.SELECT || !StringUtils.equals((String)statement.streamName, (String)se.id)) continue;
                isCSASorCTASed = true;
            }
            KsqlSynchronizer.CompatibilityAndReason compatibility = this.getCompatibility(synchronizer, se);
            boolean doCreate = false;
            if (compatibility.compatibility == KsqlSynchronizer.Compatibility.COMPATIBLE) {
                logger.info((Object)("A stream named " + se.id + " already exists and is compatible"));
                if (isCSASorCTASed) {
                    logger.info((Object)"endpoint is a  table, or a stream, target of a SELECT in the script, drop to recreate in script as a CSAS");
                    synchronizer.dropTableOrStream(se, true, true);
                }
            } else {
                if (compatibility.compatibility == KsqlSynchronizer.Compatibility.NOT_SYNCHRONIZABLE) {
                    throw new Exception("Cannot synchronize " + se.id + " to KSQL : " + compatibility.reason);
                }
                if (compatibility.compatibility == KsqlSynchronizer.Compatibility.DOES_NOT_EXIST) {
                    logger.info((Object)("No stream named " + se.id + ", synchronize one"));
                    doCreate = true;
                } else {
                    logger.info((Object)("A stream named " + se.id + " exists and is not compatible, synchronize anew (" + compatibility.reason + ")"));
                    synchronizer.dropTableOrStream(se, true, true);
                    doCreate = true;
                }
            }
            if (!doCreate || isCSASorCTASed) continue;
            synchronizer.createTableOrStream(se);
        }
    }

    public KsqlSynchronizer.CompatibilityAndReason getCompatibility(KsqlSynchronizer synchronizer, StreamingEndpoint se) throws IOException, Exception {
        KsqlSynchronizer.CompatibilityAndReason compatibility;
        if (synchronizer.getTypeIfExists(se) != null) {
            compatibility = synchronizer.checkCompatibilityWithExisting(se);
        } else {
            logger.info((Object)("No stream named " + se.id));
            compatibility = new KsqlSynchronizer.CompatibilityAndReason(KsqlSynchronizer.Compatibility.DOES_NOT_EXIST).withReason("No stream or table found via listing");
        }
        return compatibility;
    }

    public String getPreprocessedCode(KsqlRESTClient client, KsqlScriptAnalysis analysis) throws Exception {
        List<String> statements = this.getPreprocessedStatements(client, analysis);
        return Joiner.on((String)"\n;\n").join(statements) + (statements.isEmpty() ? "" : ";");
    }

    public List<String> getPreprocessedStatements(KsqlRESTClient client, KsqlScriptAnalysis analysis) throws Exception {
        KsqlSynchronizer synchronizer = new KsqlSynchronizer(client);
        ArrayList statements = Lists.newArrayList();
        for (KsqlScriptStatement statement : analysis.statements) {
            KafkaStreamingEndpointParams params;
            StreamingEndpoint se;
            if (statement.type == KsqlScriptStatementType.SELECT) {
                se = this.getEndpointByStreamName(statement);
                if (se == null) {
                    statements.add(statement.statement);
                    continue;
                }
                params = se.getParamsAs(KafkaStreamingEndpointParams.class);
                if (params.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.STREAM) {
                    statements.add(String.format("create stream `%s` with (%s)\nas\n%s", statement.streamName, synchronizer.buildStreamOrTableProperties(se, true), statement.statement));
                    continue;
                }
                statements.add(String.format("create table `%s` with (%s)\nas\n%s", statement.streamName, synchronizer.buildStreamOrTableProperties(se, true), statement.statement));
                continue;
            }
            if (statement.type == KsqlScriptStatementType.INSERT_INTO) {
                se = this.getEndpointByStreamName(statement);
                if (se == null) {
                    statements.add(statement.statement);
                    continue;
                }
                params = se.getParamsAs(KafkaStreamingEndpointParams.class);
                if (params.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.STREAM) {
                    statements.add(statement.statement);
                    continue;
                }
                statements.add(String.format("create table `%s` with (%s)\nas\n%s", statement.streamName, synchronizer.buildStreamOrTableProperties(se, true), statement.statement));
                continue;
            }
            statements.add(statement.statement);
        }
        return statements;
    }

    private StreamingEndpoint getEndpointByStreamName(KsqlScriptStatement statement) throws Exception {
        StreamingEndpoint se = null;
        for (Map.Entry<String, StreamingEndpoint> e : this.streamingEndpoints.entrySet()) {
            if (!e.getValue().id.equals(statement.streamName)) continue;
            if (se != null) {
                throw new Exception("Ambiguous stream name, several endpoints have the same name: " + statement.streamName);
            }
            se = e.getValue();
        }
        return se;
    }

    public static class KsqlScriptAnalysis {
        public List<KsqlScriptStatement> statements = Lists.newArrayList();
        public Map<KsqlScriptStatementType, Integer> countByType = Maps.newHashMap();
    }

    public static class KsqlScriptStatement {
        public KsqlScriptStatementType type;
        public String statement;
        public String select;
        public String streamName;
    }

    public static enum KsqlScriptStatementType {
        SELECT,
        INSERT_INTO,
        INSERT_VALUES,
        OTHER;

    }
}

