/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRunnable;
import com.dataiku.dip.plugin.ProgressTracker;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.scheduler.runnables.AbstractDSSRunnable;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.DSSRunnable;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.DSSRunnableUtils;
import com.dataiku.dip.scheduler.runnables.JavaRunnableDesc;
import com.dataiku.dip.scheduler.runnables.LoadedJavaRunnable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class JavaDSSRunnable
extends AbstractDSSRunnable<LoadedJavaRunnable>
implements DSSRunnable {
    private final JsonObject config;
    private final AuthCtx authCtx;
    @Autowired
    private CustomJavaRunnablesService customJavaRunnablesService;
    private static Logger logger = Logger.getLogger((String)"dip.runnables.java.regular");

    public JavaDSSRunnable(AuthCtx authCtx, String projectKey, LoadedJavaRunnable loaded, JsonObject config) {
        super(projectKey, loaded);
        this.authCtx = authCtx;
        this.config = config;
    }

    @Override
    public SmartLogTail getLogTail() {
        return null;
    }

    @Override
    public DSSRunnableResult run(File contextDir, final APITicketService.Ticket ticket) throws Exception {
        String label = ((LoadedJavaRunnable)this.loaded).runnableType;
        if (((JavaRunnableDesc)((LoadedJavaRunnable)this.loaded).desc).meta != null && StringUtils.isNotBlank((String)((JavaRunnableDesc)((LoadedJavaRunnable)this.loaded).desc).meta.label)) {
            label = ((JavaRunnableDesc)((LoadedJavaRunnable)this.loaded).desc).meta.label;
        }
        if (!this.authCtx.isAdmin()) {
            this.forceAdminParamsToDefault(this.config, ((LoadedJavaRunnable)this.loaded).desc);
        }
        logger.info((Object)("Running the macro: " + label));
        ProgressTracker progressTracker = new ProgressTracker(){

            public ProgressTracker.ProgressTrackerState beginProgress(String name) {
                return FutureProgress.pushAutoCloseableState((String)name);
            }

            public ProgressTracker.ProgressTrackerState beginProgress(String name, double target, String unit) {
                return FutureProgress.pushAutoCloseableState((String)name, (double)target, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.valueOf((String)unit));
            }
        };
        BackendClient backendClient = new BackendClient(){
            TicketBasedIntercomAPIClient apiClient;
            {
                this.apiClient = new TicketBasedIntercomAPIClient("http://localhost:" + Integer.parseInt(System.getenv("DKU_BACKEND_PORT")), null, ticket.getSecret());
            }

            public JsonElement executePost(String url, Object ... form) throws Exception {
                return (JsonElement)this.apiClient.postFormToJSON(url, JsonElement.class, form);
            }

            public JsonElement executePost(String url, Object data) throws Exception {
                return (JsonElement)this.apiClient.postObject(url, JsonElement.class, data);
            }

            public JsonElement executeGet(String url) throws Exception {
                return (JsonElement)this.apiClient.get(url, JsonElement.class);
            }

            public JsonElement executeGet(String url, Object ... form) throws Exception {
                return (JsonElement)this.apiClient.getForm(url, JsonElement.class, form);
            }

            public String getTicket() {
                return ticket.getSecret();
            }

            public Object getAuthCtx() {
                return JavaDSSRunnable.this.authCtx;
            }
        };
        ClassLoader classLoader = this.customJavaRunnablesService.getClassloader(((LoadedJavaRunnable)this.loaded).getType());
        CustomRunnable runnable = (CustomRunnable)new PluginClazzLoader(classLoader).loadClazz(((JavaRunnableDesc)((LoadedJavaRunnable)this.loaded).getDesc()).runnableClass);
        DSSRunnableResult commandResult = new DSSRunnableResult();
        try {
            PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customJavaRunnablesService.getExpandedPluginSettings(((LoadedJavaRunnable)this.loaded).getType(), this.authCtx, this.projectKey, this.config);
            runnable.init(this.projectKey, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, progressTracker, backendClient);
            byte[] data = runnable.run();
            DSSRunnableUtils.fillResult(this.projectKey, this.loaded, contextDir, commandResult, data);
        }
        catch (Exception e) {
            logger.error((Object)"Failure during runnable", (Throwable)e);
            commandResult.error = new WarningsContext.SerializedThrowable((Throwable)e);
            commandResult.type = null;
        }
        return commandResult;
    }
}

