/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios.postactions;

import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.postactions.CompressLocalconfig;
import com.dataiku.dip.scheduler.scenarios.postactions.CompressScenarioLogs;
import com.dataiku.dip.server.services.AsyncTasksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostScenarioActionsHandler {
    @Autowired
    private AsyncTasksService asyncTasksService;

    public void onEndOfScenario(ScenarioRun scenarioRun) {
        Scenario scenario = scenarioRun.getScenario();
        this.asyncTasksService.enqueue("post-scenario-actions", "Post scenario actions projectKey=" + scenario.getProjectKey() + " scenarioId=" + scenario.getId() + " scenarioRunId=" + scenarioRun.getRunId(), new ScenarioCleanuper(scenarioRun));
    }

    private static class ScenarioCleanuper
    implements Runnable {
        private final ScenarioRun scenarioRun;

        public ScenarioCleanuper(ScenarioRun scenarioRun) {
            this.scenarioRun = scenarioRun;
        }

        @Override
        public void run() {
            try {
                new CompressScenarioLogs(this.scenarioRun).run();
                new CompressLocalconfig(this.scenarioRun).run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

