/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.scheduler.model.FlowItemsToSwap;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.scheduler.utils.FlowTestUtils;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.api.client.util.Preconditions;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.google.common.collect.Lists;
import java.util.List;

public class SwapInputTestDatasetsStepRunner
implements StepRunner {
    private final Scenario scenario;
    private final SwapInputTestDatasetsStepParams params;
    private final Step step;
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "swap_datasets";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return SwapInputTestDatasetsStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new SwapInputTestDatasetsStepRunner(scenario, step, step.getParamsAs(SwapInputTestDatasetsStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            SwapInputTestDatasetsStepParams stepParams = step.getParamsAs(SwapInputTestDatasetsStepParams.class);
            if (stepParams == null) {
                return "Swap input test datasets";
            }
            StringBuilder sb = new StringBuilder("Swap input test datasets: ");
            stepParams.getSwaps().stream().filter(swap -> swap.sourceSmartName != null && swap.targetSmartName != null).findFirst().ifPresent(swap -> sb.append(String.format(" (%s, %s)", swap.sourceSmartName, swap.targetSmartName)));
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            SwapInputTestDatasetsStepParams stepParams = step.getParamsAs(SwapInputTestDatasetsStepParams.class);
            if (stepParams == null) {
                return META.getType();
            }
            StringBuilder sb = new StringBuilder(String.format("%s__", META.getType()));
            sb.append("__swap");
            stepParams.getSwaps().stream().filter(swap -> swap.sourceSmartName != null && swap.targetSmartName != null).findFirst().ifPresent(swap -> sb.append(String.format("_(%s,%s)", swap.sourceSmartName, swap.targetSmartName)));
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.swapInputTestDatasetsStepRunner");

    public SwapInputTestDatasetsStepRunner(Scenario scenario, Step step, SwapInputTestDatasetsStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone reportItem) throws Exception {
        logger.infoV("Start step %s", new Object[]{this.step.getName()});
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        DSSAuthCtx authCtx = scenarioRun.getRunAsUser();
        String contextProjectKey = this.scenario.getProjectKey();
        Preconditions.checkArgument((!this.params.getSwaps().isEmpty() ? 1 : 0) != 0, (Object)"No swaps specified");
        FlowTestUtils.assertValidSwapParams(this.params.getSwaps(), contextProjectKey);
        logger.infoV("Will swap %d flow items with their target mapping", new Object[]{this.params.getSwaps().size()});
        FlowTestUtils.swapInputDatasets(authCtx, this.params.getSwaps(), stepRun, contextProjectKey);
    }

    public static class SwapInputTestDatasetsStepParams
    extends NonFatalStepParams
    implements StepParams {
        private final List<FlowItemsToSwap> swaps = Lists.newArrayList();

        @Nonnull
        public List<FlowItemsToSwap> getSwaps() {
            return this.swaps;
        }
    }
}

