/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

public class UserImpersonationRule {
    public Scope scope;
    public String projectKey;
    public Type type;
    public String ruleFrom;
    public String dssUser;
    public String targetUnix;
    public String targetHadoop;

    public static UserImpersonationRule newGlobalSimple(String from, String to) {
        UserImpersonationRule u = new UserImpersonationRule();
        u.scope = Scope.GLOBAL;
        u.type = Type.SINGLE_MAPPING;
        u.dssUser = from;
        u.targetUnix = to;
        return u;
    }

    public static UserImpersonationRule newGlobalIdentity() {
        UserImpersonationRule u = new UserImpersonationRule();
        u.scope = Scope.GLOBAL;
        u.type = Type.IDENTITY;
        return u;
    }

    public static UserImpersonationRule newProjectSimple(String projectKey, String from, String to) {
        UserImpersonationRule u = new UserImpersonationRule();
        u.scope = Scope.PROJECT;
        u.projectKey = projectKey;
        u.type = Type.SINGLE_MAPPING;
        u.dssUser = from;
        u.targetUnix = to;
        return u;
    }

    public static UserImpersonationRule newProjectSimple(String projectKey, String from, String toUnix, String toHadoop) {
        UserImpersonationRule u = new UserImpersonationRule();
        u.scope = Scope.PROJECT;
        u.projectKey = projectKey;
        u.type = Type.SINGLE_MAPPING;
        u.dssUser = from;
        u.targetUnix = toUnix;
        u.targetHadoop = toHadoop;
        return u;
    }

    public static UserImpersonationRule newGlobalRegexp(String from, String to) {
        UserImpersonationRule u = new UserImpersonationRule();
        u.scope = Scope.GLOBAL;
        u.type = Type.REGEXP_RULE;
        u.ruleFrom = from;
        u.targetUnix = to;
        return u;
    }

    public static enum Scope {
        GLOBAL,
        PROJECT;

    }

    public static enum Type {
        SINGLE_MAPPING,
        REGEXP_RULE,
        IDENTITY;

    }
}

