/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.rpc;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ssl.SslContextFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class EncryptedRPC {
    private static final String B64PREFIX = "b64:";

    public static boolean enabled() {
        return "true".equals(DKUApp.getIniValue((String)"rpc", (String)"encrypted", (String)"false"));
    }

    public static File getPEMCertificateFile() {
        return DKUApp.getFile((String[])new String[]{"install-support", "encrypted-rpc", "cert.pem"});
    }

    public static File getP12CertificateAndKeyFile() {
        return DKUApp.getFile((String[])new String[]{"install-support", "encrypted-rpc", "certandkey.p12"});
    }

    public static String getP12CertificateAndKeyStorePassword() {
        return "password";
    }

    public static String getPEMCertificateText() {
        try {
            return DKUFileUtils.readFileToStringUTF8((File)EncryptedRPC.getPEMCertificateFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read Encrypted RPC certificate", e);
        }
    }

    private static String getPEMCertificateTextB64() {
        String rawText = EncryptedRPC.getPEMCertificateText();
        return EncryptedRPC.encodePEMCertificateTextB64(rawText);
    }

    static String encodePEMCertificateTextB64(String text) {
        return B64PREFIX + Base64.encodeBase64String((byte[])text.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodePEMCertificateTextB64(String text) {
        return new String(Base64.decodeBase64((String)text.substring(B64PREFIX.length())), StandardCharsets.UTF_8);
    }

    public static boolean isEncodedTextB64(String text) {
        return StringUtils.isNotBlank((String)text) && text.startsWith(B64PREFIX);
    }

    public static SSLContext getSSLContext() throws Exception {
        if (!EncryptedRPC.enabled()) {
            return null;
        }
        SslContextFactory.Server sslContextFactoryServer = EncryptedRPC.getSSLContextFactoryServer();
        try {
            sslContextFactoryServer.start();
            SSLContext sSLContext = sslContextFactoryServer.getSslContext();
            return sSLContext;
        }
        finally {
            sslContextFactoryServer.stop();
        }
    }

    public static SslContextFactory.Server getSSLContextFactoryServer() {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(EncryptedRPC.getP12CertificateAndKeyFile().getAbsolutePath());
        sslContextFactory.setKeyStorePassword(EncryptedRPC.getP12CertificateAndKeyStorePassword());
        sslContextFactory.setKeyStoreType("PKCS12");
        return sslContextFactory;
    }

    public static String getPEMCertificateTextB64orNA() {
        if (!EncryptedRPC.enabled()) {
            return "NA";
        }
        return EncryptedRPC.getPEMCertificateTextB64();
    }
}

