/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.sso.SSOUserSupplier;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSSSOUserSupplier
extends SSOUserSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    @Autowired
    public DSSSSOUserSupplier(GeneralSettingsDAO gsDAO, PubSubService pubSubService) {
        this.ssoSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().ssoSettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = gsDAO.getUnsafeAutoTXN();
                this.ssoSettings = generalSettings.ssoSettings;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

