/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.inline.InlineDatasetConfig;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.export.input.ExportShaker;
import com.dataiku.dip.export.input.RemotableExportInput;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.UsabilityComputer;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetDescriptionsService;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.datasets.DatasetRenameService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.datasets.EditableDatasetImporter;
import com.dataiku.dip.server.datasets.EditableDatasetService;
import com.dataiku.dip.server.services.ConflictCheckService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.DatasetNotebookService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.TwitterConnectorsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.shaker.filter.ExplorationFilterToStepsConverter;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DatasetExploreSettingsDAO;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.MaybeDone;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.WithMessages;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DatasetsCRUDController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private DatasetAccessService accessService;
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    private DatasetDeletionService deletionService;
    @Autowired
    private DatasetRenameService renameService;
    @Autowired
    private DatasetNotebookService notebookService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private TwitterConnectorsService twitterConnectorsService;
    @Autowired
    private EditableDatasetService editableDatasetService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private ConflictCheckService conflictCheckService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private PluginUsagesInspector pluginUsagesInspector;
    @Autowired
    private ManagedDatasetsCreationService managedDatasetsCreationService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;
    @Autowired
    private DatasetDescriptionsService datasetDescriptionsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.datasets.controller");

    @AuditedCall(value={"msgType", "datasets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter, @RequestParam(required=false, defaultValue="false") boolean withStatus) throws Exception {
        AuthCtx u;
        TaggableObjectsService.FilteredTaggableItems<DatasetListItem> heads = new TaggableObjectsService.FilteredTaggableItems<DatasetListItem>();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List sds = this.datasetsDAO.listUnsafe(projectKey);
            for (SerializedDataset sd : sds) {
                try {
                    if (!TagFilterUtils.matches(tf, sd)) {
                        ++heads.filteredOut;
                        continue;
                    }
                    DatasetListItem head = new DatasetListItem(sd);
                    this.taggableObjectsService.setEditionInfoFromTags(sd, head);
                    heads.items.add(head);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read dataset " + sd.projectKey + "." + sd.name), (Throwable)e);
                }
            }
        }
        this.interestsService.enrichListItems(u.getAssociatedDSSUser(), projectKey, heads.items);
        if (withStatus) {
            this.datasetMetricsStatusService.addSizeAndRecordsToDatasets(projectKey, heads);
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "datasets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/list-headers"})
    public void listHeaders(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseService.failIfLocked();
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ArrayList<DatasetHeader> out = new ArrayList<DatasetHeader>();
            for (SerializedDataset inObj : this.datasetsDAO.listUnsafe(projectKey)) {
                DatasetHeader dh = new DatasetHeader();
                dh.name = inObj.name;
                dh.type = inObj.type;
                dh.managed = inObj.managed;
                if (inObj.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
                    dh.params = new JsonObject();
                    AbstractSQLDatasetHandler.AbstractSQLConfig typedParams = (AbstractSQLDatasetHandler.AbstractSQLConfig)inObj.getParams();
                    dh.params.addProperty("mode", typedParams.mode);
                }
                out.add(dh);
            }
            DatasetsCRUDController.writeJSON((HttpServletResponse)resp, out);
        }
    }

    @AuditedCall(value={"msgType", "datasets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/list-names"})
    public void listNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<String> datasetsNames;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            datasetsNames = this.datasetsDAO.listUsedNames(projectKey);
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, datasetsNames);
    }

    @AuditedCall(value={"msgType", "datasets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List list;
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseService.failIfLocked();
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            list = this.datasetsDAO.listUnsafe(projectKey);
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "datasets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/list-with-accessible"})
    public void listWithAccessible(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List list;
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseService.failIfLocked();
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            list = this.datasetsDAO.listUnsafe(projectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedDatasets(projectKey)) {
                try {
                    SerializedDataset accessibleDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
                    if (accessibleDataset == null) continue;
                    list.add(accessibleDataset);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to read dataset", (Throwable)e);
                }
            }
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${name}"})
    @RequestMapping(value={"/api/datasets/get-with-metrics-status"})
    public void getWithMetricsStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        SerializedDataset sds;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseService.failIfLocked();
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sds = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, name);
        }
        InterestsService.TaggableObjectWithUserInterest ret = this.interestsService.getObjectAndUserInterest_NT(u, sds);
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${name}"})
    @RequestMapping(value={"/api/datasets/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summ = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = (TaggableObjectsService.TaggableObject)this.datasetsDAO.getMandatoryUnsafe(projectKey, name);
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, name, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, name);
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${name}"})
    @RequestMapping(value={"/api/datasets/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        AuthCtx u;
        AnyLoc loc = new AnyLoc(projectKey, name);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDatasetReadUseAccess(u, loc, contextProjectKey);
            SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
            try {
                UsabilityComputer.checkDatasetAvailable(this.pluginUsagesInspector, serializedDataset);
            }
            catch (Exception e) {
                logger.error((Object)"Error when checking dataset availability", (Throwable)e);
            }
        }
        NavigatorService.DatasetFullInfo info = this.navigatorService.getDatasetFullInfo_NT(loc, contextProjectKey, u);
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${name}"})
    @RequestMapping(value={"/api/datasets/get-public-info"})
    public void getPublicInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        NavigatorService.DatasetFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = new AnyLoc(projectKey, name);
            this.projectsService.failIfNoDashboardReadPermission(u, new SmartObjectRef(ITaggingService.TaggableType.DATASET, name), contextProjectKey);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
            try {
                UsabilityComputer.checkDatasetAvailable(this.pluginUsagesInspector, sd);
            }
            catch (Exception e) {
                logger.error((Object)"Error when checking dataset availability", (Throwable)e);
            }
            info = this.navigatorService.getDatasetPublicInfo(loc, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "dataset-set-dataset-descriptions", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "shortDesc", "${shortDesc}", "longDesc", "${longDesc}", "colDesc", "${colDesc}"})
    @RequestMapping(value={"/api/datasets/set-dataset-descriptions"}, method={RequestMethod.POST})
    @ResponseBody
    public SerializedDataset setDatasetDescriptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String shortDesc, @RequestParam String longDesc, @RequestParam String colDesc) throws Exception {
        AuthCtx authCtx;
        Map serializedColDesc = (Map)JSON.parse((String)colDesc, (TypeToken)new TypeToken<Map<String, String>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseService.failIfLocked();
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        return this.datasetDescriptionsService.setDatasetDescriptionsAndColumnDescriptions(authCtx, projectKey, datasetName, shortDesc, longDesc, serializedColDesc);
    }

    @AuditedCall(value={"msgType", "dataset-set-data-steward", "projectKey", "${projectKey}", "name", "${name}", "dataSteward", "${dataSteward}"})
    @RequestMapping(value={"/api/datasets/set-data-steward"})
    public void setDataSteward(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam @Nullable String dataSteward) throws Exception {
        AuthCtx authCtx;
        String parsedDataSteward = StringUtils.defaultIfEmpty((String)dataSteward, null);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            List<UsersService.UIUser> users = this.usersService.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx);
            if (parsedDataSteward != null && users.stream().noneMatch(u -> u.login.equals(parsedDataSteward))) {
                throw ErrorContext.iaef((String)"Invalid data steward: %s is not an enabled user.", (Object)dataSteward, (Object[])new Object[0]);
            }
        }
        t = this.transactionService.beginWriteForUI(req);
        try {
            SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, name);
            String currentDataSteward = serializedDataset.getDataSteward();
            if (!Objects.equals(currentDataSteward, parsedDataSteward)) {
                serializedDataset.setDataSteward(parsedDataSteward);
                this.saveService.save(projectKey, name, serializedDataset, authCtx);
                t.commit((parsedDataSteward == null ? "Unset" : "Set") + " data steward for dataset " + name);
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${name}"})
    @RequestMapping(value={"/api/datasets/get"})
    @ResponseBody
    public SerializedDataset get(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String name, @RequestParam String contextProjectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseService.failIfLocked();
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, name, contextProjectKey);
            this.projectsService.failIfNoDashboardReadPermission(authCtx, ref, contextProjectKey);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, name);
            sd.setAllFieldsToNonRawMode();
            SerializedDataset serializedDataset = sd;
            return serializedDataset;
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${name}"})
    @RequestMapping(value={"/api/datasets/get-for-export"})
    public void getForExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam String contextProjectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseService.failIfLocked();
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, name, contextProjectKey);
            this.projectsService.failIfNoDashboardReadPermission(authCtx, ref, contextProjectKey);
            this.projectsService.checkPerm(authCtx, contextProjectKey, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, name);
            DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)sd);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/export"})
    public void export(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String name, @RequestParam(required=false, defaultValue="{}") String params) throws Exception {
        ExportStatus ret;
        try (Transaction t = this.transactionService.beginRead();){
            RemotableExportInput input;
            AuthCtx user = this.authService.getMandatoryUser(req);
            SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, name, contextProjectKey);
            this.projectsService.failIfNoDashboardReadPermission(user, ref, contextProjectKey);
            this.projectsService.checkPerm(user, contextProjectKey, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA);
            ExportParams exportParams = (ExportParams)JSON.parse((String)params, ExportParams.class);
            exportParams.contextProjectKey = contextProjectKey;
            Dataset dbs = this.accessService.getMandatory(projectKey, name);
            exportParams.filenameBase = dbs.getName();
            SerializedShakerScript.TableColoring coloring = this.retrieveTableColoring(exportParams, projectKey, name);
            if (exportParams.applyExplorationFilters) {
                ExportParams.ExplorationFiltersAndSearchQuery exportFilters = this.retrieveActualFilters(exportParams, projectKey, name);
                if (exportFilters.isActive()) {
                    SerializedShakerScript script = new SerializedShakerScript();
                    script.contextProjectKey = contextProjectKey;
                    script.steps = new ExplorationFilterToStepsConverter().convert(exportFilters);
                    script.coloring = coloring;
                    input = new ExportShaker(dbs, script, dbs.getName(), user);
                } else {
                    input = new ExportDataset(user, dbs.serialize(), ExportUtils.convertColoring(coloring));
                }
            } else {
                input = new ExportDataset(user, dbs.serialize(), ExportUtils.convertColoring(coloring));
            }
            ret = this.exportService.handleExportRequest(user, input, exportParams);
            this.auditTrailService.generic("dataset-export").with("projectKey", projectKey).with("datasetName", name).with("contextProjectKey", contextProjectKey).with("exportId", ret.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-export", (Throwable)e).with("projectKey", projectKey).with("datasetName", name).with("contextProjectKey", contextProjectKey).emit();
            throw e;
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    private ExportParams.ExplorationFiltersAndSearchQuery retrieveActualFilters(ExportParams exportParams, String projectKey, String projectName) throws IOException {
        if (exportParams.explorationFiltersAndSearchQuery != null) {
            return exportParams.explorationFiltersAndSearchQuery;
        }
        DatasetExploreSettingsDAO exploreSettingsDAO = (DatasetExploreSettingsDAO)SpringUtils.getBean(DatasetExploreSettingsDAO.class);
        DatasetExploreSettings exploreSettings = exploreSettingsDAO.getUnsafe(projectKey, projectName);
        ExportParams.ExplorationFiltersAndSearchQuery result = new ExportParams.ExplorationFiltersAndSearchQuery();
        if (exploreSettings != null && exploreSettings.script != null) {
            result.explorationFilters = exploreSettings.script.explorationFilters;
            result.globalSearchQuery = exploreSettings.script.globalSearchQuery;
        }
        return result;
    }

    private SerializedShakerScript.TableColoring retrieveTableColoring(ExportParams exportParams, String projectKey, String projectName) throws IOException {
        DatasetExploreSettingsDAO exploreSettingsDAO;
        DatasetExploreSettings exploreSettings;
        if (exportParams.applyColoring && (exploreSettings = (exploreSettingsDAO = (DatasetExploreSettingsDAO)SpringUtils.getBean(DatasetExploreSettingsDAO.class)).getUnsafe(projectKey, projectName)) != null && exploreSettings.script != null) {
            return exploreSettings.script.coloring;
        }
        return null;
    }

    @AuditedCall(value={"msgType", "list-dataset-types-with-no-connection", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/list-creatable-dataset-types"})
    public void listCreatableDatasetTypes(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ManagedDatasetsCreationService.CreatableDatasetTypes creatableDatasetTypes;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            creatableDatasetTypes = this.managedDatasetsCreationService.listCreatableDatasetTypes(authCtx, projectKey);
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)creatableDatasetTypes);
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/create"}, method={RequestMethod.POST})
    @ResponseBody
    public SerializedDataset createDatasetWithData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="data") SerializedDataset sds, @RequestParam(required=false) String zoneId) throws Exception {
        block26: {
            Dataset dataset;
            AuthCtx authCtx = null;
            DatasetUtils.checkName(sds.name);
            try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
                authCtx = t.getUser();
                this.licenseService.failIfLocked();
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                this.checkConnection(sds, req);
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
                dsCtx.setZoneId(zoneId);
                WithMessages<SerializedDataset> created = this.saveService.create(projectKey, sds, dsCtx, t.getUser());
                sds = (SerializedDataset)created.value;
                if (created.messages.warning) {
                    logger.warn((Object)"Warnings were encountered in dataset creation (but external, so not showing to the user");
                    for (InfoMessage message : created.messages.messages) {
                        logger.warn((Object)(message.code + ": " + message.message));
                    }
                }
                dataset = Dataset.fromSerialized(projectKey + "." + sds.name, sds);
                t.commit("Created dataset " + dataset.getFullName());
            }
            catch (Exception e) {
                this.auditTrailService.failure("dataset-create", (Throwable)e).with("projectKey", sds.projectKey).with("datasetName", sds.name).emit();
                throw e;
            }
            try {
                if ("Inline".equals(dataset.getType())) {
                    EditableDatasetImporter importer = new EditableDatasetImporter(authCtx, projectKey, dataset.getParamsAs(InlineDatasetConfig.class), dataset.getFormatType(), dataset.getFormatParams(), true);
                    importer.import_NT(dataset);
                }
            }
            catch (Exception e) {
                this.auditTrailService.failure("dataset-create", (Throwable)e).with("projectKey", sds.projectKey).with("datasetName", sds.name).emit();
                throw e;
            }
            try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, Dataset.fromSerialized(sds));){
                if (!dh.executeSlowPostCreateOperations_NT()) break block26;
                try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
                    sds = dh.getDataset().serialize();
                    this.saveService.saveWithoutEvents(projectKey, dh.getDataset().getName(), sds, t.getUser());
                    t.commit("Created dataset " + dh.getDataset().getFullName() + " (post-creation auto-commit)");
                }
            }
        }
        this.auditTrailService.generic("dataset-create").with("projectKey", sds.projectKey).with("datasetName", sds.name).emit();
        return sds;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/check-save-conflict"}, method={RequestMethod.POST})
    public void checkSaveConflict(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedDataset newDataset = (SerializedDataset)JSON.parse((String)data, SerializedDataset.class);
            this.checkConnection(newDataset, req);
            if (newDataset.name == null) {
                throw new IllegalArgumentException("Can't save a dataset with no name");
            }
            SerializedDataset existingDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, newDataset.name);
            VersionTag.ConflictCheckResult ccr = existingDataset != null ? this.conflictCheckService.checkConflict(existingDataset.versionTag, newDataset.versionTag) : this.conflictCheckService.checkConflict(null, newDataset.versionTag);
            if (!ccr.canBeSaved) {
                ccr.message = "This dataset is being edited by more than one user.";
            }
            DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ccr);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/save"}, method={RequestMethod.POST})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        SerializedDataset sds = (SerializedDataset)JSON.parse((String)data, SerializedDataset.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.checkConnection(sds, req);
            if (sds.name == null) {
                throw new IllegalArgumentException("Can't save a dataset with no name");
            }
            String fullName = sds.projectKey + "." + sds.name;
            Dataset updated = Dataset.fromSerialized(fullName, sds);
            WithMessages<SerializedDataset> savedDataset = this.saveService.save(projectKey, updated.getName(), updated.serialize(), t.getUser());
            if (si.summaryOnly) {
                t.commit("Updated summary for dataset " + fullName, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved dataset " + fullName);
            }
            this.auditTrailService.generic("dataset-save").with("projectKey", projectKey).with("datasetName", sds.name).emit();
            DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)((SerializedDataset)savedDataset.value).versionTag);
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-save", (Throwable)e).with("projectKey", projectKey).with("datasetName", sds.name).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/save-with-recipes-fixup"}, method={RequestMethod.POST})
    public void saveWithRecipesFixup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, @RequestParam(required=false) String saveInfo, @RequestParam boolean forceRecipesFixup) throws Exception {
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        SerializedDataset sds = (SerializedDataset)JSON.parse((String)data, SerializedDataset.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.checkConnection(sds, req);
            if (sds.name == null) {
                throw new IllegalArgumentException("Can't save a dataset with no name");
            }
            String fullName = sds.projectKey + "." + sds.name;
            Dataset updated = Dataset.fromSerialized(fullName, sds);
            MaybeDone<SerializedDataset> savedDataset = this.saveService.saveWithRecipesFixup(projectKey, updated.getName(), updated.serialize(), forceRecipesFixup);
            if (savedDataset.isDone()) {
                if (si.summaryOnly) {
                    t.commit("Updated summary for dataset " + fullName, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                } else {
                    t.commit("Saved dataset " + fullName);
                }
                this.auditTrailService.generic("dataset-save").with("projectKey", projectKey).with("datasetName", sds.name).emit();
            }
            DatasetsCRUDController.writeJSON((HttpServletResponse)resp, savedDataset);
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-save", (Throwable)e).with("projectKey", projectKey).with("datasetName", sds.name).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "dataset-rename", "projectKey", "${projectKey}", "oldName", "${oldName}", "newName", "${newName}"})
    @RequestMapping(value={"/api/datasets/rename"})
    public void renameDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String oldName, @RequestParam String newName) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        DatasetUtils.checkName(newName);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            dataset = this.accessService.getMandatory(projectKey, oldName);
            if (!oldName.equalsIgnoreCase(newName) && this.datasetsDAO.datasetExistsCaseInsensitive(projectKey, newName)) {
                throw ErrorContext.iaef((String)"Dataset '%s' already exists", (Object)newName, (Object[])new Object[0]);
            }
            if (this.streamingEndpointsDAO.exists(projectKey, newName)) {
                throw ErrorContext.iaef((String)"Name %s is already used by a streaming endpoint", (Object)newName, (Object[])new Object[0]);
            }
        }
        DatasetRenameService.RenamingImpact impact = this.renameService.computeRenamingImpact(dataset);
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.renameService.performRenaming(authCtx, dataset, newName, impact));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/compute-renaming-impact"})
    public void computeRenamingImpact(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        Dataset ds;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ds = this.accessService.getMandatory(projectKey, name);
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.renameService.computeRenamingImpact(ds));
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/set-virtualizable"})
    public void setVirtualizable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items, @RequestParam boolean virtualizable) throws Exception {
        List refs = (List)JSON.parse((String)items, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                this.projectsService.checkPerm(req, ref.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                SerializedDataset sds = this.accessService.getMandatory(ref.getLoc()).getModel();
                sds.flowOptions.virtualizable = virtualizable;
                this.saveService.save(sds.projectKey, sds.name, sds, authCtx);
            }
            t.commit("Changed virtualizable for datasets");
        }
        catch (Exception e) {
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                this.auditTrailService.failure("dataset-set-virtualizable", (Throwable)e).with("projectKey", ref.projectKey).with("datasetName", ref.id).with("virtualizable", virtualizable).emit();
            }
            throw e;
        }
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            this.auditTrailService.generic("dataset-set-virtualizable").with("projectKey", ref.projectKey).with("datasetName", ref.id).with("virtualizable", virtualizable).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/set-auto-count-of-records"})
    public void setAutoCountOfRecords(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items, @RequestParam String autoCountOfRecords) throws Exception {
        List refs = (List)JSON.parse((String)items, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        boolean enable = "true".equals(autoCountOfRecords);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                try {
                    this.projectsService.checkPerm(req, ref.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                    boolean isLocal = ref.projectKey.equals(ref.getLoc().resolved().getProjectKey());
                    if (!isLocal) {
                        ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Skip foreign dataset: " + ref.id);
                        logger.info((Object)"Set auto compute count of records: skip foreign dataset");
                        continue;
                    }
                    if (ref.type != ITaggingService.TaggableType.DATASET) {
                        throw ErrorContext.iaef((String)"%s is not a dataset (type: %s)", (Object)ref.id, (Object[])new Object[]{ref.type.toHumanReadableString()});
                    }
                    SerializedDataset sd = this.accessService.getMandatory(ref.getLoc()).getModel();
                    Probe.ComputeMode mode = Probe.ComputeMode.NO;
                    if (enable) {
                        mode = sd.isPartitioned() ? Probe.ComputeMode.BOTH : Probe.ComputeMode.PARTITION;
                    }
                    for (Probe probe : sd.getMetrics().probes) {
                        if (!"records".equals(probe.type)) continue;
                        probe.enabled = true;
                        probe.computeOnBuildMode = mode;
                        break;
                    }
                    this.saveService.save(sd.projectKey, sd.name, sd, authCtx);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to set auto compute count of records", (Throwable)e);
                    ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed for dataset " + String.valueOf(ref));
                }
            }
            t.commit((enable ? "Enabled" : "Disabled") + " auto compute count of records for " + (String)(refs.size() > 1 ? refs.size() + " datasets" : ((TaggableObjectsService.TaggableObjectRef)refs.get(0)).getLoc().getFullName()));
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-clear-data-partitions", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "partitions", "${partitions}"})
    @RequestMapping(value={"/api/datasets/clear-partitions"})
    public void clearPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partitions) throws Exception {
        Dataset ds;
        List pids = (List)JSON.parse((String)partitions, (TypeToken)new TypeToken<ArrayList<String>>(){});
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ds = this.accessService.getMandatory(projectKey, datasetName);
        }
        this.deletionService.clearPartitions_NT(authCtx, ds, pids);
    }

    @AuditedCall(value={"msgType", "notebooks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/list-notebooks"})
    public void listNotebooks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName) throws Exception {
        List<DatasetNotebookService.SimpleNotebook> list;
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNotEmpty(new String[]{datasetSmartName});
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            list = this.notebookService.listDatasetNotebooks(projectKey, datasetSmartName);
        }
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "datasets-twitter-streamcontrol", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/datasets/control-twitter-streaming"})
    public void controlTwitterStreaming(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, boolean start) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.accessService.getMandatory(projectKey, name);
            if (start) {
                this.twitterConnectorsService.startStreaming(projectKey + "." + name);
            } else {
                this.twitterConnectorsService.stopStreaming(projectKey + "." + name);
            }
            t.commit("Changed twitter configuration to " + projectKey + "." + name);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/get-twitter-status"})
    public void getTwitterStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset ds = this.accessService.getOrNull(projectKey, name);
            TwitterStatus status = new TwitterStatus();
            if (ds != null) {
                status.isStarted = this.twitterConnectorsService.isStarted(ds.getFullName());
                status.hasData = this.twitterConnectorsService.hasData(ds.getFullName());
            }
            DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)status);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/mark-as-built"})
    public void markAsBuilt(HttpServletRequest req, HttpServletResponse resp, @RequestParam String datasets) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            List refs = (List)JSON.parse((String)datasets, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                this.projectsService.checkPerm(authCtx, ref.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                this.neverBuiltComputablesCacheService.remove(ref);
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-editable-save", "projectKey", "${projectKey}", "datasetName", "${dataset}"})
    @RequestMapping(value={"/api/datasets/editable/save"})
    public void saveEditableDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataset, @RequestParam String data) throws Exception {
        EditableDatasetService.EditableDatasetSaveResult res;
        Dataset ds;
        EditableDatasetService.EditableDatasetSaveQuery query = (EditableDatasetService.EditableDatasetSaveQuery)JSON.parse((String)data, EditableDatasetService.EditableDatasetSaveQuery.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, dataset);
            ds = this.accessService.getMandatory(loc);
            this.editableDatasetService.checkEditable(ds);
            if (!query.force) {
                VersionTag.ConflictCheckResult ccr = this.conflictCheckService.checkConflict(ds.serialize().versionTag, query.versionTag);
                if (!ccr.canBeSaved) {
                    DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ccr);
                    return;
                }
            }
            res = this.editableDatasetService.save(ds, query, t.getUser());
            t.commit("Saved editable dataset: " + ds.getFullName());
        }
        this.datasetDeletionService.clearCacheAndStatus_NT(ds);
        DatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "dataset-editable-import", "projectKey", "${projectKey}", "datasetName", "${dataset}"})
    @RequestMapping(value={"/api/datasets/editable/import"})
    public void importEditableDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataset, @RequestParam String data) throws Exception {
        SerializedDataset fakeDs = (SerializedDataset)JSON.parse((String)data, SerializedDataset.class);
        AnyLoc outputLoc = AnyLoc.resolveSmart(projectKey, dataset);
        String lockName = "datasets.editable.import." + outputLoc.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            Dataset outputDS;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                outputDS = this.accessService.getMandatory(outputLoc);
                this.editableDatasetService.checkEditable(outputDS);
            }
            EditableDatasetImporter importer = new EditableDatasetImporter(authCtx, projectKey, fakeDs.getParamsAs(InlineDatasetConfig.class), fakeDs.formatType, fakeDs.getFormatParams(), false);
            importer.import_NT(outputDS);
        }
    }

    private void checkConnection(SerializedDataset sds, HttpServletRequest req) throws Exception {
        if (sds.getParams().getConnection() != null) {
            this.connectionsService.checkUserForConnection(this.authService.getMandatoryUser(req), sds.getParams().getConnection());
        }
    }

    public static class DatasetListItem
    extends TaggableObjectsService.TaggableListItem {
        final String type;
        final boolean managed;
        final boolean partitioned;
        final DatasetMetricsStatusService.DatasetSummaryStatus status;

        public DatasetListItem(SerializedDataset sds) {
            super(sds);
            this.type = sds.type;
            this.managed = sds.managed;
            this.partitioned = sds.partitioning != null && sds.partitioning.isPartitioned();
            this.status = new DatasetMetricsStatusService.DatasetSummaryStatus();
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.DATASET;
        }
    }

    static class DatasetHeader {
        String name;
        String type;
        boolean managed;
        JsonObject params;

        DatasetHeader() {
        }
    }

    public static class TwitterStatus {
        boolean isStarted = false;
        boolean hasData = false;
    }

    public static class RecipeLink {
        public String projectKey;
        public String name;
        public String id;
        public String type;
    }
}

