/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.kernel.master.BuildService;
import com.dataiku.dip.dataflow.streaming.slave.ContinuousActivityKernel;
import com.dataiku.dip.dataflow.streaming.slave.ContinuousActivityRunner;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class JobsIntercomPrivilegedController
extends DIPInternalControllerBase {
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private FlowExecutionService2 service;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private BuildService buildService;
    @Autowired
    private AppsService appsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/jobs/kernel-register"})
    public void registerKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelId, @RequestParam int port, @RequestParam int jvmPID) throws IOException {
        this.authService.failIfNoSharedSecret(req);
        this.buildService.onRegister(kernelId, port, jvmPID);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/jobs/continuous-kernel-register"})
    public void registerContinuousKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelId, @RequestParam int port) throws IOException {
        this.authService.failIfNoSharedSecret(req);
        ContinuousActivityKernel kernel = ContinuousActivityRunner.getStartingKernel(kernelId);
        if (kernel == null) {
            throw new IllegalArgumentException("Continuous activity kernel " + kernelId + " not found");
        }
        kernel.onRegister(port);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/jobs/start"})
    @ResponseBody
    public Id startIntercom(HttpServletRequest req, @RequestParam(name="data") JobDef jobDef) throws Exception {
        String jobId;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNoSharedSecret(req);
            DSSAuthCtx u = DSSAuthCtx.fakeForTests("dku-cli");
            jobDef.initiationTimestamp = System.currentTimeMillis();
            jobDef.initiator = u.getIdentifier();
            jobId = this.service.startJob(jobDef, u);
        }
        return new Id(jobId);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/jobs/get-job-status"})
    @ResponseBody
    public EnhancedSerializedJobStatus getJobStatusIntercom(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String jobId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNoSharedSecret(req);
        }
        EnhancedSerializedJobStatus status = this.service.getStatus_NT(projectKey, jobId);
        try (Transaction t = this.transactionService.beginRead();){
            this.service.addInitiator(status);
            EnhancedSerializedJobStatus enhancedSerializedJobStatus = status;
            return enhancedSerializedJobStatus;
        }
    }
}

