/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.ITaggingService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class HrefMarkupFormatter
extends MarkupFormatter {
    private final HrefContext href;

    public HrefMarkupFormatter(HrefContext href, Markup markup, List<UsersDAO.User> users) {
        super(markup, users);
        this.href = href;
    }

    @Override
    public String root(String label) {
        return this.a(this.href.root(), label);
    }

    @Override
    public String project(String projectKey, String displayName, String discussionId) {
        return this.a(this.href.project(projectKey), displayName, discussionId);
    }

    @Override
    public String dataset(String projectKey, String datasetName, String discussionId) {
        return this.a(this.href.dataset(projectKey, datasetName), datasetName, discussionId);
    }

    @Override
    public String recipe(String projectKey, String recipeName, String discussionId) {
        return this.a(this.href.recipe(projectKey, recipeName), recipeName, discussionId);
    }

    @Override
    public String analysis(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.analysis(projectKey, id), displayName, discussionId);
    }

    @Override
    public String savedModel(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.savedModel(projectKey, id), displayName, discussionId);
    }

    @Override
    public String modelEvaluationStore(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.modelEvaluationStore(projectKey, id), displayName, discussionId);
    }

    @Override
    public String folder(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.folder(projectKey, id), displayName, discussionId);
    }

    @Override
    public String streamingEndpoint(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.streamingEndpoint(projectKey, id), displayName, discussionId);
    }

    @Override
    public String scenario(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.scenario(projectKey, id), displayName, discussionId);
    }

    @Override
    public String scenarioRuns(String projectKey, String id, String displayName) {
        return this.a(this.href.scenarioRuns(projectKey, id), displayName);
    }

    @Override
    public String insight(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.insight(projectKey, id), displayName, discussionId);
    }

    @Override
    public String jupyterNotebook(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.jupyterNotebook(projectKey, id), displayName, discussionId);
    }

    @Override
    public String sqlNotebook(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.sqlNotebook(projectKey, id), displayName, discussionId);
    }

    @Override
    public String searchNotebook(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.searchNotebook(projectKey, id), displayName, discussionId);
    }

    @Override
    public String lambdaService(String projectKey, String id, String discussionId) {
        return this.a(this.href.lambdaService(projectKey, id), id, discussionId);
    }

    @Override
    public String webapp(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.webapp(projectKey, id), displayName, discussionId);
    }

    @Override
    public String codeStudio(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.codeStudio(projectKey, id), displayName, discussionId);
    }

    @Override
    public String report(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.report(projectKey, id), displayName, discussionId);
    }

    @Override
    public String article(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.article(projectKey, id), displayName, discussionId);
    }

    @Override
    public String dashboard(String projectKey, String id, String displayName, String discussionId) {
        return this.a(this.href.dashboard(projectKey, id), displayName, discussionId);
    }

    @Override
    public String workspace(String workspaceKey, String displayName, String discussionId) {
        return this.a(this.href.workspace(workspaceKey), displayName, discussionId);
    }

    @Override
    public String workspaceObject(String workspaceKey, ITaggingService.TaggableType objectType, String projectKey, String objectId, String displayName, String discussionId) {
        return this.a(this.href.workspaceObject(workspaceKey, objectType, projectKey, objectId), displayName, discussionId);
    }

    @Override
    public String request(String requestId, String displayName) {
        return this.a(this.href.request(requestId), displayName);
    }

    @Override
    public String dataCollection(String dataCollectionId, String displayName) {
        return this.a(this.href.dataCollection(dataCollectionId), displayName);
    }

    @Override
    public String user(String login, String displayName) {
        String ret = displayName;
        if (StringUtils.isBlank((String)ret)) {
            ret = (String)this.userDisplayNames.get(login);
        }
        if (StringUtils.isBlank((String)ret)) {
            ret = login;
        }
        return this.a(this.href.user(login), ret);
    }

    @Override
    public String job(String projectKey, String id, String displayName) {
        return this.a(this.href.job(projectKey, id), displayName);
    }

    @Override
    public String continuousActivity(String projectKey, String id, String displayName) {
        return this.a(this.href.continuousActivity(projectKey, id), displayName);
    }

    @Override
    public String mlTask(String projectKey, String analysisId, MLTask.MLTaskType taskType, String id, String displayName) {
        return this.a(this.href.mlTask(projectKey, analysisId, taskType, id), displayName);
    }

    @Override
    public String udm(String id, String displayName) {
        return this.a(this.href.udm(id), displayName);
    }

    @Override
    public String plugin(String id, String displayName) {
        return this.a(this.href.plugin(id), displayName);
    }

    @Override
    public String connection(String id, String displayName) {
        return this.a(this.href.connection(id), displayName);
    }

    @Override
    public String text(Object text) {
        return this.markup.text(Objects.toString(text));
    }

    @Override
    public String lineBreak() {
        return this.markup.lineBreak();
    }

    @Override
    public String nbspace() {
        return this.markup.nbspace();
    }

    private String a(String url, String innerText, String discussionId) {
        Object discussionSuffix = StringUtils.isNotBlank((String)discussionId) ? "?discussionId=" + discussionId : "";
        return this.markup.link(url + (String)discussionSuffix, innerText);
    }

    private String a(String url, String innerText) {
        return this.a(url, innerText, null);
    }
}

