/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.AccessGrantedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractRequestAccessEmailBuilder;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GrantedAccessEmailBuilder
extends AbstractRequestAccessEmailBuilder<AccessGrantedEvent> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private GeneralSettingsService generalSettingsService;

    public GrantedAccessEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected String makeBody(AccessGrantedEvent evt, PublicUser srcUser, SerializedProject project, String objectDisplayName) throws IOException, TemplateException {
        HrefContext href;
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "access-granted-email.ftl"});
        VariableLookup lookup = new VariableLookup();
        SerializedProject targetProject = null;
        try (Transaction ignored = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)settings.studioExternalUrl) ? null : settings.studioExternalUrl);
            lookup.addVariable("dssInstanceName", settings.nodeName);
            lookup.addVariable("emailPreferencesLink", settings.studioExternalUrl + "/profile/");
            href = new HrefContext(settings.studioExternalUrl);
            if (evt.getRequestType().isSharingRequest()) {
                targetProject = this.projectsService.getMandatory(evt.getTargetProjectKey());
            }
        }
        lookup.addVariable("objectType", (Object)evt.getObjectType());
        lookup.addVariable("openButtonLabel", evt.getObjectType().toString().replace("_", " "));
        lookup.addVariable("projectName", project.name);
        if (evt.getRequestType().isSharingRequest()) {
            String objectTypeName = evt.getObjectType().toTaggableType().get().toHumanReadableString();
            lookup.addVariable("title", "You have been granted access to a " + objectTypeName);
            lookup.addVariable("requestAction", "You can now use a " + objectTypeName + " in a project");
            lookup.addVariable("projectLink", href.project(project.projectKey));
            lookup.addVariable("iconPath", this.getObjectIconPath(evt));
            lookup.addVariable("objectName", objectDisplayName);
            lookup.addVariable("objectLink", this.getObjectLink(evt, href));
            if (targetProject != null) {
                lookup.addVariable("targetProjectLink", href.project(targetProject.projectKey));
                lookup.addVariable("targetProjectName", targetProject.name);
            }
        } else if (evt.getObjectType() == Request.RequestObjectType.APP) {
            lookup.addVariable("title", "You have been granted rights to execute an app");
            lookup.addVariable("requestAction", "You can now use a dataiku app from the following project:");
            lookup.addVariable("projectLink", href.application(evt.getObjectId()));
            lookup.addVariable("objectLink", href.application(evt.getObjectId()));
        }
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }

    @Override
    protected String makeSubject(AccessGrantedEvent evt, PublicUser srcUser, String objectDisplayName) {
        switch (evt.getRequestType()) {
            case PROJECT_EXECUTE_APP: {
                return "You have been granted rights to execute an app";
            }
            case OBJECT_SHARE: {
                return "You have been granted access to a " + evt.getObjectType().toTaggableType().get().toHumanReadableString();
            }
        }
        return "";
    }
}

