/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.pivot.PivotSQLGenerator;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PivotRecipeService {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    protected DatasetsDAO datasetsDAO;

    private void expandParams(PivotRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getContext(projectKey);
        FilterDescUtils.expand(params.preFilter, vc);
        ComputedColumnUtils.expand(vc, params.computedColumns);
    }

    public PivotRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        PivotRecipePayloadParams params = (PivotRecipePayloadParams)JSON.parse((String)payload, PivotRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey);
        return params;
    }

    public String generatePivotingSQL(JobActivity activity, SQLDialect dialect, PivotRecipePayloadParams params, boolean forceOutputColumnNameOverride) throws IOException {
        Partition part;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        Dataset target = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams) && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && !parts.isEmpty() && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(target) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && target.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = target.getPartitioningSchema();
        }
        List<String> identifiers = params.buildIdentifierList(source.getSchema());
        SQLUtils.SQLTable sqlTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
        PivotSQLGenerator generator = new PivotSQLGenerator(params, source, sqlTable, target);
        generator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
        PivotElementsModalitiesSnapshot modalities = PivotRecipeSchemaComputer.getPivotElementsModalitiesIfUptodate(params, target.getSchema());
        if (modalities == null) {
            throw new IllegalArgumentException("Cannot generate query if modalities are not up to date");
        }
        return generator.generateQuery(identifiers, modalities.pivotElementsModalities, dialect, forceOutputColumnNameOverride).toSQL(dialect);
    }
}

