/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.connections.PineconeConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.VectorStoreConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.backend.ConnectionChangedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TwitterConnectorsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionsService {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TwitterConnectorsService twitterConnectorsService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PermissionsService permissionsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections");

    public PineconeConnection getPineconeConnection(AuthCtx u, String pineconeConnection) throws IOException, DKUSecurityException, Exception {
        DSSConnection connection = this.connectionsDAO.getConnection(u, pineconeConnection);
        if (connection == null || !connection.isFreelyUsableBy(u)) {
            throw new Exception("Pinecone connection doesn't exist, or isn't accessible.");
        }
        if (!(connection instanceof PineconeConnection)) {
            throw new Exception("Connection is not a valid Pinecone connection");
        }
        return (PineconeConnection)connection;
    }

    public List<VectorStoreConnection.SanitisedConnectionForKB> listUsableVectorStoreConnections(AuthCtx u) throws IOException {
        List<DSSConnection> usableConnections = this.getUsableConnections(u, DSSConnection.class);
        List usableKBConnections = usableConnections.stream().filter(conn -> conn instanceof VectorStoreConnection && conn.allowKnowledgeBanks).collect(Collectors.toList());
        return usableKBConnections.stream().map(conn -> ((VectorStoreConnection)((Object)conn)).getSanitisedConnection()).collect(Collectors.toList());
    }

    public void failIfCannotSaveConnection(AuthCtx authCtx, DSSConnection connection) throws IOException {
        DSSConnection prev = this.connectionsDAO.list().get(connection.name);
        if (!authCtx.isAdmin()) {
            if (((DSSAuthCtx)authCtx).getPermissions().mayCreateAuthenticatedConnections()) {
                if (!connection.mayBeSavedAsPersonalConnectionByNonAdmin()) {
                    throw new SecurityException("You may not save this kind of connection");
                }
                if (!(prev == null || prev.owner != null && prev.owner.equals(authCtx.getIdentifier()))) {
                    throw new SecurityException("You may not save this connection");
                }
            } else {
                throw new SecurityException("You do not have required privileges");
            }
        }
    }

    public void save(AuthCtx authCtx, DSSConnection c2, boolean creation) throws IOException, CodedException, DKUSecurityException {
        ConnectionChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)c2.name, (Object)"Name must not be null");
        this.failIfCannotSaveConnection(authCtx, c2);
        Map<String, DSSConnection> map = this.connectionsDAO.list();
        DSSConnection prev = map.get(c2.name);
        if (!authCtx.isAdmin()) {
            c2.owner = authCtx.getIdentifier();
        }
        if (c2 instanceof ConnectionWithEncryptedFields) {
            ((ConnectionWithEncryptedFields)((Object)c2)).encryptFields(this.cryptoService, this.generalSettingsDAO.getUnsafe().security);
        }
        ConnectionChangedEvent.ActionType actionType = action = creation ? ConnectionChangedEvent.ActionType.CREATED : ConnectionChangedEvent.ActionType.EDITED;
        if (prev == null) {
            c2.creationTag = new VersionTag(authCtx.getAssociatedDSSUserOrIdentifier());
        }
        if (prev != null && prev.dataikuCloudAccessRestriction != null) {
            logger.debugV("Maybe-enforcing Dataiku Cloud access restriction %s on connection %s", new Object[]{prev.dataikuCloudAccessRestriction, c2.name});
            if (!this.permissionsService.hasAdditionalCloudDataikerAdminPermission(authCtx) && prev.dataikuCloudAccessRestriction == DSSConnection.DataikuCloudConnectionAccessRestriction.NO_CHANGES) {
                throw new UnauthorizedException("cannot change connection", "connection-cloud-no-changes");
            }
        }
        if (creation) {
            this.customFieldsService.enrichWithDefaultCustomFieldsForConnection(c2);
        }
        this.customPolicyHooksRegistry.onPreConnectionSave(authCtx, this.connectionsDAO.list().get(c2.name), c2);
        map.put(c2.name, c2);
        PublicUser pu = this.usersService.getPublicUser(authCtx.getAssociatedDSSUserOrIdentifier());
        this.pubSub.publishAfterTransaction(new ConnectionChangedEvent(c2.name, c2.type, authCtx.getIdentifier(), pu == null ? null : pu.displayName, action));
        this.connectionsDAO.writeList(map);
        this.updateTwitterActiveConnection();
    }

    public void checkUserForConnection(AuthCtx liu, String connection) throws DKUSecurityException {
        try {
            ErrorContext.checkNotNull((Object)connection, (String)"Connection is null");
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(liu, connection);
            if (!conn.isFreelyUsableBy(liu)) {
                throw new UnauthorizedException("Access to this connection is not authorized.", "connection-access-denied");
            }
        }
        catch (IOException e) {
            throw new UnauthorizedException("Could not check access to this connection.", "connection-access-check-failed", (Throwable)e);
        }
    }

    private void updateTwitterActiveConnection() throws DKUSecurityException, IOException {
        List<String> connections;
        try {
            connections = this.connectionsDAO.getConnectionNames("Twitter", null, false);
        }
        catch (IOException e) {
            logger.error((Object)"Failure to get twitter type connections");
            return;
        }
        if (connections.size() == 0) {
            this.twitterConnectorsService.setActiveConnection(null);
        }
        if (connections.size() == 1) {
            this.twitterConnectorsService.setActiveConnection(connections.get(0));
        }
    }

    public List<SQLUtils.SQLField> listSQLFields(DSSConnection conn, FieldsRequest fr, AuthCtx authCtx, String projectKey) throws Exception {
        if (conn instanceof MetastoreDBBasedConnection) {
            MetastoreDBBasedConnection hconn = (MetastoreDBBasedConnection)((Object)conn);
            HiveSQLDialect dialect = new HiveSQLDialect();
            String impaliveDbName = hconn.getDatabaseName();
            String clusterId = StringUtils.isBlank((String)projectKey) ? "__builtin__" : new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
            logger.info((Object)("Listing Metastore fields on connection=" + String.valueOf(conn) + " project=" + projectKey + " cluster=" + clusterId));
            ArrayList<SQLUtils.SQLField> outFields = new ArrayList<SQLUtils.SQLField>();
            for (SQLUtils.SQLTable table : fr.tables) {
                List<ColumnSchema> hiveTableSchema = this.metastoreInspectionService.newInspector(authCtx, projectKey).listColumns(clusterId, impaliveDbName, table.getTable(), authCtx, projectKey);
                for (ColumnSchema cs2 : hiveTableSchema) {
                    SQLUtils.SQLField f = new SQLUtils.SQLField();
                    f.name = cs2.name;
                    f.quotedName = dialect.quoteIdentifier(cs2.name);
                    f.table = table.getTable();
                    f.type = cs2.type;
                    outFields.add(f);
                }
            }
            return outFields;
        }
        if (conn instanceof AbstractSQLConnection) {
            SQLConnectionProvider.SQLConnectionData sqlData = ((AbstractSQLConnection)conn).getConnectionData_NT(authCtx, projectKey);
            return SQLUtils.listFields(sqlData, fr.tables, authCtx, projectKey);
        }
        throw ErrorContext.iae((String)("Invalid connection type " + conn.getType()));
    }

    public List<SQLTableWithQuotedName> listSQLTableForConnection(DSSConnection conn, AuthCtx authCtx, String projectKey, String catalog, String schema) throws Exception {
        if (conn instanceof MetastoreDBBasedConnection) {
            MetastoreDBBasedConnection hconn = (MetastoreDBBasedConnection)((Object)conn);
            String clusterId = StringUtils.isBlank((String)projectKey) ? "__builtin__" : new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
            return this.metastoreInspectionService.newInspector(authCtx, projectKey).listSQLTableForConnection(authCtx, clusterId, hconn.getDatabaseName(), projectKey);
        }
        if (conn instanceof AbstractSQLConnection) {
            SQLConnectionProvider.SQLConnectionData sqlData = ((AbstractSQLConnection)conn).getConnectionData_NT(authCtx, projectKey);
            ArrayList<SQLTableWithQuotedName> sqlTables = new ArrayList<SQLTableWithQuotedName>();
            for (SQLUtils.SQLTable table : SQLUtils.listTables(sqlData, authCtx, projectKey, catalog, schema)) {
                sqlTables.add(new SQLTableWithQuotedName(table, sqlData.getDialect()));
            }
            return sqlTables;
        }
        throw ErrorContext.iae((String)("Invalid connection type " + conn.getType()));
    }

    public FutureResponse<List<String>> listSqlSchemasForCatalog(final SQLConnectionProvider.SQLConnectionData connData, final AuthCtx authCtx, final String projectKey, final @Nullable String catalog) throws Exception {
        SimpleFutureThread<List<String>> simpleFutureThread = new SimpleFutureThread<List<String>>(authCtx){

            @Override
            protected List<String> compute() throws Exception {
                if (connData.getDialect().isCatalogAware()) {
                    String finalCatalog = SQLUtils.resolveCatalogFromConnectionDefault(connData, catalog);
                    List<String> schemaList = SQLUtils.listSchemasForCatalog(connData, authCtx, projectKey, finalCatalog);
                    Stream sortedSchemas = schemaList.stream().sorted();
                    if (finalCatalog == null) {
                        return sortedSchemas.distinct().collect(Collectors.toList());
                    }
                    return sortedSchemas.collect(Collectors.toList());
                }
                return SQLUtils.listSchemasCatalogUnaware(connData, authCtx, projectKey);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"list_SQL_schemas_for_connection", (String)("Listing all schemas for connection " + connData.getConnection().name));
            }
        };
        return this.futureService.runFuture(simpleFutureThread, 10L, new TypeToken<FutureResponse<List<String>>>(){});
    }

    public FutureResponse<List<String>> listSqlCatalogs(final SQLConnectionProvider.SQLConnectionData connData, final AuthCtx authCtx, final String projectKey) throws Exception {
        SimpleFutureThread<List<String>> simpleFutureThread = new SimpleFutureThread<List<String>>(authCtx){

            @Override
            protected List<String> compute() throws Exception {
                return SQLUtils.listCatalogs(connData, authCtx, projectKey);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"list_SQL_catalogs_for_connection", (String)("Listing all catalogs for connection " + connData.getConnection().name));
            }
        };
        return this.futureService.runFuture(simpleFutureThread, 10L, new TypeToken<FutureResponse<List<String>>>(){});
    }

    public List<SQLDatasetMapping> getTableDatasetMapping(AuthCtx authCtx, String connection) throws IOException, DKUSecurityException {
        DSSConnection requestedConnection = this.connectionsDAO.getMandatoryConnection(authCtx, connection);
        ArrayList<SQLDatasetMapping> mapping = new ArrayList<SQLDatasetMapping>();
        for (String projectKey : this.projectsService.listProjectKeys()) {
            for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(projectKey)) {
                try {
                    SQLDatasetMapping map = new SQLDatasetMapping();
                    map.dataset = dataset.name;
                    map.projectKey = projectKey;
                    if (DatasetInspector.isSQL(dataset)) {
                        String dsConnection = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)dataset.projectKey).connection;
                        if (!StringUtils.equals((String)dsConnection, (String)connection)) continue;
                        map.schema = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).schema;
                        map.table = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)projectKey).table;
                        mapping.add(map);
                        continue;
                    }
                    if (!DatasetInspector.canHiveTable(dataset) || !(requestedConnection instanceof MetastoreDBBasedConnection)) continue;
                    MetastoreDBBasedConnection hconn = (MetastoreDBBasedConnection)((Object)requestedConnection);
                    String datasetHiveDatabaseName = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(Dataset.fromSerializedUnsafe(dataset)).getSchemaNullIfBlank();
                    if (!StringUtils.equals((String)hconn.getDatabaseName(), (String)datasetHiveDatabaseName)) continue;
                    map.schema = null;
                    map.table = dataset.name;
                    mapping.add(map);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to get mapping for dataset" + dataset.projectKey + "." + dataset.name + ", ignoring"), (Throwable)e);
                }
            }
        }
        return mapping;
    }

    public void delete(List<String> names, AuthCtx authCtx) throws IOException, DKUSecurityException {
        for (String name : names) {
            this.delete(name, authCtx);
        }
    }

    public void delete(String name, AuthCtx authCtx) throws IOException, DKUSecurityException {
        Map<String, DSSConnection> map = this.connectionsDAO.list();
        if (map.containsKey(name)) {
            DSSConnection c2 = map.remove(name);
            this.connectionsDAO.writeList(map);
            this.updateTwitterActiveConnection();
            String userDisplayName = this.usersService.getPublicUser((String)authCtx.getIdentifier()).displayName;
            this.pubSub.publishAfterTransaction(new ConnectionChangedEvent(name, c2.type, authCtx.getIdentifier(), userDisplayName, ConnectionChangedEvent.ActionType.DELETED));
        }
    }

    private <T extends DSSConnection> List<T> getUsableConnections(AuthCtx authCtx, Class<T> ofClazz) throws IOException {
        ArrayList usableConnections = Lists.newArrayList();
        for (DSSConnection connection : this.connectionsDAO.listUnsafe().values()) {
            if (!connection.isFreelyUsableBy(authCtx) || !ofClazz.isInstance(connection)) continue;
            usableConnections.add(connection);
        }
        return usableConnections;
    }

    public List<AbstractSQLConnection> getUsableSqlConnections(AuthCtx authCtx) throws IOException {
        return this.getUsableConnections(authCtx, AbstractSQLConnection.class);
    }

    public List<ElasticSearchConnection> getUsableElasticSearchConnections(AuthCtx authCtx) throws IOException {
        return this.getUsableConnections(authCtx, ElasticSearchConnection.class);
    }

    public List<HDFSConnection> listUsableHdfsConnectionsUnsafe(AuthCtx authCtx, String restrictToConnection) throws IOException {
        ArrayList conns = Lists.newArrayList();
        for (DSSConnection conn : this.connectionsDAO.listUnsafe().values()) {
            if (!conn.isFreelyUsableBy(authCtx) || !(conn instanceof HDFSConnection) || !StringUtils.isBlank((String)restrictToConnection) && !restrictToConnection.equals(conn.name)) continue;
            conns.add((HDFSConnection)conn);
        }
        Collections.sort(conns, new Comparator<HDFSConnection>(){

            @Override
            public int compare(HDFSConnection a, HDFSConnection b) {
                int cmp = (a.allowManagedDatasets ? 0 : 1) - (b.allowManagedDatasets ? 0 : 1);
                return cmp;
            }
        });
        return conns;
    }

    public List<HDFSAbleConnection> listUsableHdfsAbleConnectionsUnsafe(AuthCtx authCtx, String restrictToConnection) throws IOException {
        ArrayList conns = Lists.newArrayList();
        for (DSSConnection conn : this.connectionsDAO.listUnsafe().values()) {
            if (!conn.isFreelyUsableBy(authCtx) || !(conn instanceof HDFSAbleConnection) || !StringUtils.isBlank((String)restrictToConnection) && !restrictToConnection.equals(conn.name)) continue;
            conns.add((HDFSAbleConnection)((Object)conn));
        }
        Collections.sort(conns, new Comparator<HDFSAbleConnection>(){

            @Override
            public int compare(HDFSAbleConnection a, HDFSAbleConnection b) {
                int cmp = (a.allowManagedDatasets() ? 0 : 1) - (b.allowManagedDatasets() ? 0 : 1);
                return cmp;
            }
        });
        return conns;
    }

    public Map<String, DSSConnection> listUnsafe() throws IOException {
        return this.connectionsDAO.listUnsafe();
    }

    public DSSConnection get(String connection) throws IOException {
        return this.connectionsDAO.list().get(connection);
    }

    public DSSConnection getUnsafe(String connection) throws IOException {
        return this.connectionsDAO.listUnsafe().get(connection);
    }

    public List<EnrichedLLMStructuredRef> listAvailableConnectionLLMs(AuthCtx authCtx, AbstractLLMConnection.LLMUsagePurpose purpose) throws IOException {
        ArrayList<EnrichedLLMStructuredRef> remoteLLMList = new ArrayList<EnrichedLLMStructuredRef>();
        for (DSSConnection connection : this.connectionsDAO.listUnsafe().values()) {
            if (!connection.isFreelyUsableBy(authCtx) || !(connection instanceof AbstractLLMConnection)) continue;
            AbstractLLMConnection llmConnection = (AbstractLLMConnection)connection;
            remoteLLMList.addAll(llmConnection.listAvailableLLMStructuredRefs(purpose));
        }
        return remoteLLMList;
    }

    public static class FieldsRequest {
        public List<SQLUtils.SQLTable> tables;
    }

    public static class SQLTableWithQuotedName
    extends SQLUtils.SQLTable {
        public final String quoted;

        public SQLTableWithQuotedName(String catalog, String schema, String table, SQLDialect dialect, boolean isTrueTable) {
            this(catalog, schema, table, dialect.getQuotedTableFullName(catalog, schema, table), isTrueTable);
        }

        public SQLTableWithQuotedName(SQLUtils.SQLTable table, SQLDialect dialect) {
            this(table, dialect.getQuotedTableFullName(table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable()));
        }

        SQLTableWithQuotedName(String catalog, String schema, String table, String quoted, boolean isTrueTable) {
            super(catalog, schema, table, isTrueTable);
            this.quoted = quoted;
        }

        SQLTableWithQuotedName(SQLUtils.SQLTable table, String quoted) {
            super(table);
            this.quoted = quoted;
        }
    }

    public static class SQLDatasetMapping {
        String table;
        String schema;
        String dataset;
        String projectKey;
    }

    public static class SQLTableWithQuotedNameAndDataset
    extends SQLTableWithQuotedName {
        String dataset;

        public SQLTableWithQuotedNameAndDataset(String catalog, String schema, String table, String datasets, SQLDialect dialect, boolean isTrueTable) {
            super(catalog, schema, table, dialect.getQuotedTableFullName(catalog, schema, table), isTrueTable);
            this.dataset = datasets;
        }
    }
}

