/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.git.jgit.DSSSingleRepositoryGitManager;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.git.jgit.MultiRepositoryProjectsGitManager;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.UserEditable;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public class DKUTransactionService
implements AutoCloseable,
TransactionService {
    private File configDir;
    private TransactionProvider provider;

    public DKUTransactionService() throws IOException {
        this.configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, true, false));
    }

    public DKUTransactionService(boolean gitSupport) throws IOException {
        this.configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, gitSupport, false));
    }

    public DKUTransactionService(File anotherRoot, boolean exclusive) throws IOException {
        this.configDir = anotherRoot;
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(exclusive, true, true, false));
    }

    @VisibleForTesting
    public DKUTransactionService(boolean gitSupport, boolean forceCacheV1) throws IOException {
        this.configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, forceCacheV1, gitSupport, false));
    }

    public void changeRoot(File anotherRoot, boolean exclusive, boolean gitSupport) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        this.provider.close();
        this.configDir = anotherRoot;
        this.provider = new TransactionProvider(anotherRoot, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(exclusive, true, gitSupport, false));
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req, boolean checkXSRF) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForAPI(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForTicket(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteAsLoggedInUser(AuthCtx usr, boolean committable) {
        assert (usr != null) : "User cannot be null";
        TransactionContext.assertNoAttachedTransaction();
        if (this.provider == null) {
            throw new RuntimeException("The DKU transaction provider has been closed");
        }
        RWTransaction rw = this.provider.beginWrite(usr, committable);
        try {
            ((UserEditable)rw).setUser(usr);
            TransactionContext.attach((TransactionRef)rw);
            return rw;
        }
        catch (Throwable t) {
            rw.close();
            throw t;
        }
    }

    public RWTransaction beginWriteAsDSS(boolean committable) {
        DSSAuthCtx dss = DSSAuthCtx.newNone();
        return this.beginWriteAsLoggedInUser(dss, committable);
    }

    public Transaction beginRead(IsolationLevel isolationLevel, @Nullable String fakeStack) {
        TransactionContext.assertNoAttachedTransaction();
        if (this.provider == null) {
            throw new RuntimeException("The DKU transaction provider has been closed");
        }
        Transaction t = this.provider.beginRead(isolationLevel, fakeStack);
        TransactionContext.attach((TransactionRef)t);
        return t;
    }

    public File resolve(RelFile file) {
        return file.resolve(this.configDir);
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public JGitManager getGitManager() {
        Object gitManager = null;
        try {
            DSSGitModel.GitMode mode = ApplicationConfigurator.getGitMode();
            File configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
            switch (mode) {
                case PROJECT: {
                    gitManager = new MultiRepositoryProjectsGitManager(configDir);
                    break;
                }
                case GLOBAL: {
                    gitManager = new DSSSingleRepositoryGitManager(configDir);
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
        }
        catch (Exception ex) {
            throw new NotImplementedException("unable to setup jGitManager");
        }
        return gitManager;
    }

    public void performDirectCommit(DSSCommitDef def) throws IOException {
        this.provider.performDirectCommit((CommitDef)def);
    }

    public void flushPendingCommits(String projectKey) throws IOException {
        this.provider.flushPendingCommits(projectKey);
    }

    public void clearCache() {
        this.provider.clearCache();
    }

    public void invalidateCache(RelFile file) {
        this.provider.invalidateCache(file);
    }

    public CachedReadFS getCache() {
        return this.provider.getCache();
    }
}

