/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.notifications.backend.ScenarioRunFailedCheckLogsEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScenariosBaseService {
    @Autowired
    private UsersService usersService;
    @Autowired
    private PublicAPIKeysService publicApiKeyService;
    @Autowired
    private PubSubService pubSub;
    private static DKULogger logger = DKULogger.getLogger(ScenariosBaseService.class);

    public String computeRunAsUser(Scenario scenario) {
        String runAsUser = scenario.getRunAsUser();
        if (StringUtils.isNotBlank((String)runAsUser)) {
            return runAsUser;
        }
        if (scenario.getVersionTag() != null) {
            return scenario.getVersionTag().getLastAuthor();
        }
        if (scenario.getCreationTag() != null) {
            return scenario.getCreationTag().getLastAuthor();
        }
        return "";
    }

    public DSSAuthCtx getRunAsUser(Scenario scenario) throws SQLException, IOException, UnauthorizedException {
        String runAsUser = this.computeRunAsUser(scenario);
        if (StringUtils.isBlank((String)runAsUser)) {
            String msg = String.format("Configured to run as 'Last user', but could not find it", new Object[0]);
            this.pubSub.publish(new ScenarioRunFailedCheckLogsEvent(scenario.projectKey, scenario.id, scenario.name, msg));
            throw new UnauthorizedException(String.format("Cannot run scenario %s.%s: configured to run as 'Last user' but could not find it", scenario.getProjectKey(), scenario.getId()), "scenario-invalid-run-as");
        }
        UsersDAO.User user = this.usersService.getInternalUserOrNullUnsafe(runAsUser);
        try {
            PublicAPIKey apiKey;
            if (user != null) {
                return DSSAuthCtx.forUserLogin(user);
            }
            if (runAsUser.startsWith("api:") && (apiKey = this.publicApiKeyService.getKeyById(runAsUser.substring(4))) != null) {
                return DSSAuthCtx.forAPIKey(apiKey);
            }
        }
        catch (NotLoggedInException e) {
            logger.warnV("Failed to use run as user for scenario run %s.%s: %s: %s", new Object[]{scenario.getProjectKey(), scenario.getId(), runAsUser, ExceptionUtils.getMessageWithCauses((Throwable)e)});
            this.pubSub.publish(new ScenarioRunFailedCheckLogsEvent(scenario.projectKey, scenario.id, scenario.name, String.format("Configured to run as user '%s'. %s", runAsUser, ExceptionUtils.getMessageWithCauses((Throwable)e))));
            throw new UnauthorizedException(String.format("Cannot run scenario %s.%s, configured to run as user '%s': %s", scenario.getProjectKey(), scenario.getId(), runAsUser, ExceptionUtils.getMessageWithCauses((Throwable)e)), "scenario-invalid-run-as");
        }
        this.pubSub.publish(new ScenarioRunFailedCheckLogsEvent(scenario.projectKey, scenario.id, scenario.name, String.format("Configured to run as user '%s' which does not exist", runAsUser)));
        throw new UnauthorizedException(String.format("Cannot run scenario %s.%s: configured to run as user '%s' which does not exist", scenario.getProjectKey(), scenario.getId(), runAsUser), "scenario-invalid-run-as");
    }
}

