/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingClientConnectionManager;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class RemoteLicenseService {
    private HttpClient client;
    private static Logger logger = Logger.getLogger((String)"dss.ssaas");

    public RemoteLicenseService() {
        DefaultHttpClient defaultClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        defaultClient.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        this.client = defaultClient;
    }

    public License getLicense() throws Exception {
        String nodeId;
        String licenseKey = ApplicationConfigurator.getMandatoryProperty((String)"licenseKey");
        String managerURL = ApplicationConfigurator.getMandatoryProperty((String)"saasManagerURL");
        HttpGet get = new HttpGet(managerURL + "/api/onpremise/instance/get-license?instanceLicenseKey=" + licenseKey + "&nodeId=" + (nodeId = LicenseUtils.getMainNodeId()));
        HttpResponse resp = this.client.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() != 200) {
            String ret = new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent()), "utf8");
            try {
                APIError apiErr = (APIError)JSON.parse((String)ret, APIError.class);
                ret = apiErr.message;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("Getting license failed: " + ret);
        }
        return (License)JSON.parse((String)new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent())), License.class);
    }
}

