/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.utils.Pair;
import com.google.gson.JsonObject;

public abstract class FilterAndFlagProcessor
extends AppliesToProcessor
implements Processor {
    protected Column flagColumn;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.getParams().action == Action.FLAG) {
            this.flagColumn = this.getFlagColumn();
        }
    }

    protected Column getFlagColumn() {
        if (this.getParams().appliesTo == AppliesToProcessor.AppliesTo.PATTERN || this.getParams().appliesTo == AppliesToProcessor.AppliesTo.ALL) {
            return this.getColumnFactory().column(this.getParams().flagColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
        return this.getColumnFactory().columnAfter((String)this.getParams().columns.get(0), this.getParams().flagColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public static void applyActionSingle(Action action, boolean matches, Row row, Column clearColumn, Column flagColumn) {
        switch (action) {
            case FLAG: {
                if (!matches) break;
                row.put(flagColumn, 1);
                break;
            }
            case DONTCLEAR_CELL: {
                if (matches) break;
                row.delete(clearColumn);
                break;
            }
            case CLEAR_CELL: {
                if (!matches) break;
                row.delete(clearColumn);
                break;
            }
            case REMOVE_ROW: {
                if (!matches) break;
                row.delete();
                break;
            }
            case KEEP_ROW: {
                if (matches) break;
                row.delete();
            }
        }
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
        if (this.getParams().action == Action.KEEP_ROW || this.getParams().action == Action.REMOVE_ROW || this.getParams().action == Action.FLAG) {
            boolean anyMatch = false;
            boolean allMatch = true;
            for (Column column : columns) {
                if (this.flagColumn != null && column.getName().equals(this.flagColumn.getName())) continue;
                boolean match = this.matchCell(row, column);
                allMatch &= match;
                anyMatch |= match;
            }
            boolean doAction = this.getParams().booleanMode == BooleanMode.AND ? allMatch : anyMatch;
            switch (this.getParams().action) {
                case DONTCLEAR_CELL: 
                case CLEAR_CELL: {
                    assert (false);
                    break;
                }
                case FLAG: {
                    if (!doAction) break;
                    row.put(this.flagColumn, 1);
                    break;
                }
                case KEEP_ROW: {
                    if (doAction) break;
                    row.delete();
                    break;
                }
                case REMOVE_ROW: {
                    if (!doAction) break;
                    row.delete();
                }
            }
        } else {
            for (Column column : columns) {
                boolean match = this.matchCell(row, column);
                switch (this.getParams().action) {
                    case FLAG: 
                    case REMOVE_ROW: 
                    case KEEP_ROW: {
                        assert (false);
                        break;
                    }
                    case DONTCLEAR_CELL: {
                        if (match) break;
                        row.delete(column);
                        break;
                    }
                    case CLEAR_CELL: {
                        if (!match) break;
                        row.delete(column);
                    }
                }
            }
        }
    }

    public static JsonObject selfReport(FilterAndFlagParams parameter) {
        JsonObject obj = AppliesToProcessor.selfReport(parameter);
        obj.remove("flagColumn");
        obj.remove("clearColumn");
        return obj;
    }

    @Override
    public abstract FilterAndFlagParams getParams();

    public abstract boolean matchCell(Row var1, Column var2) throws Exception;

    public static abstract class FilterAndFlagParams
    extends AppliesToProcessor.AppliesToParams
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public Action action = Action.KEEP_ROW;
        public BooleanMode booleanMode = BooleanMode.AND;
        public String flagColumn;
    }

    public static enum Action {
        KEEP_ROW,
        REMOVE_ROW,
        CLEAR_CELL,
        DONTCLEAR_CELL,
        FLAG;

    }

    public static enum BooleanMode {
        AND,
        OR;

    }

    public static abstract class FilterProcessorMeta<T extends FilterAndFlagProcessor, P extends FilterAndFlagParams>
    extends AppliesToProcessor.AppliesToProcessorMeta<T, P> {
        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof FilterAndFlagParams)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                for (String outputColumn : previousDatasetPairLineage.getOutputColumns()) {
                    updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage(pss.params, updatedDatasetPairLineage, outputColumn, AppliesToProcessor.AppliesToProcessorMeta.RelationDirection.TO, false, true);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    }

    public static abstract class FlagProcessorMeta<T extends FilterAndFlagProcessor, P extends FilterAndFlagParams>
    extends AppliesToProcessor.AppliesToProcessorMeta<T, P> {
        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof FilterAndFlagParams)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            FilterAndFlagParams flagOnValueParams = (FilterAndFlagParams)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage(flagOnValueParams, (DatasetPairLineage)previousDatasetPairLineage, flagOnValueParams.flagColumn, AppliesToProcessor.AppliesToProcessorMeta.RelationDirection.TO, false);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    }
}

